package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.Command;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginProperties;


/**
 * This command displays a status line message with the version of its
 * associated plugin.
 *
 * @author Lawrence Cabac
 */
public class VersionInfoCommand extends Command {
    IPlugin _plugin;

    /**
     * Creates an <code>VersionInfoCommand</code> for the given plugin.
     * @param plugin the plugin instance whose version is of interest.
     */
    public VersionInfoCommand(IPlugin plugin) {
        super("About  v " + plugin.getVersion());

        _plugin = plugin;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void execute() {
        DrawPlugin current = DrawPlugin.getCurrent();
        current.showStatus(_plugin.getLongVersion());
        System.out.println("\n");
        System.out.println(_plugin.getLongVersion());
        PluginProperties props = _plugin.getProperties();
        System.out.println("Compilation date is: " + props.getFilteredProperty("compile.date"));
        System.out.println("\n");
    }
}