package CH.ifa.draw.application;

import java.io.File;
import java.io.FilenameFilter;

import de.renew.util.StringUtil;


/**
 * FileByExtensionFilter.java
 *
 *
 * Created: Wed Apr 19  2000
 * Modified: Mon May 15  2000
 *
 * @author Michael Duvigneau
 * @author Frank Wienberg
 */
public class FileByExtensionFilter implements FilenameFilter {
    /**
     * Retrieve a logger named according to the value of the name parameter.
     * If the named logger already exists, then the existing instance will be returned.
     * Otherwise, a new instance is created.
     */
    public static org.apache.log4j.Logger logger =
        org.apache.log4j.Logger.getLogger(FileByExtensionFilter.class);
    /**
     * An Array of Strings that contains all the extension for the filters
     */
    private String[] extensions;

    /**
     * Writes input extensions array on field extensions array (of class FileBYExtensionsFilter)
     * @param extensions array of extensions
     */
    public FileByExtensionFilter(String[] extensions) {
        logger.debug("created" + extensions.length);
        if (extensions.length == 0) {
            extensions = null;
        }
        this.extensions = extensions;
    }

    @Override
    public boolean accept(File dir, String name) {
        if (extensions == null) {
            return true;
        } else {
            String ext = StringUtil.getExtension(name);
            logger.debug("ext:" + ext);
            for (int i = 0; i < extensions.length; i++) {
                logger.debug("???:" + extensions[i]);
                if (extensions[i].equals(name)) {
                    logger.debug("yes");
                    return true;
                }
            }
            logger.debug("no");
            return false;
        }
    }
}