package CH.ifa.draw.application;

import java.awt.Dimension;
import java.awt.Point;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.StandardDrawingView;

/**
 * View container supplier for a drawing.
 */
public interface DrawingViewContainerSupplier {
    /**
     * Gets a DrawingViewContainer.
     * @param appl DrawApplication, the DrawingApplication for this container (presentation of the drawing editor)
     * @param drawing Drawing, that is in the container
     * @param drawingView StandardDrawingView, that is chosen for the Container
     * @param loc Point, the Location of the container
     * @param size Dimension, size of the container
     * @return DrawingViewContainer that has the parameters listed above
     */
    //Todo: DrawingApplication is deprecated since 2018 -> alteration of code needed
    //Todo: This method does not do much in the implementation, which should be evaluated
    public DrawingViewContainer getContainer(
        DrawApplication appl, StandardDrawingView drawingView, Drawing drawing, Point loc,
        Dimension size);
}