# CH

The CH package provides a massively modified version of the JHotDraw
drawing editor.
The main class, `CH.ifa.draw.DrawPlugin`, provides several interface methods
that can be used by other plugins to extend the functionality.
Right now, those objects include:

## Menu Handling
### a) Menu commands
To add a menu to the JHotDraw Gui, you use the MenuManager class, an
instance of which can be obtained by the `getMenuManager()` method of the
current DrawPlugin.  It is VERY IMPORTANT that the menu/menu item you are
registering identifies itself, or it will not be added.

The identification is done by using the `putClientProperty()`; the key String
to use as its first parameter must be `ch.ifa.draw.menu.id` (which is
stored as the public static final String member `MenuManager.ID_PROPERTY`).
The object to be put into this property (i.e., the second parameter) must
be a unique String (it is encouraged to use your plugin's provision as a
prefix).  You must keep your menu object referenced so you can unregister
it again when your plugin is unloaded.  If removing a previously registered
menu causes its parent menu to become empty, that parent is also removed.

To create a separator in a menu, you must create a pseudo JMenuItem to
register it.  This Separator can be obtained by the
`MenuManager.SeparatorFactory`
inner class.  It is instantiated by a String containing the prefix that you
use for your `ID_PROPERTY`. Separators need (and can) not be unregistered;
rather, they are removed automatically.

- `registerMenu(String toplevel, JMenuItem toAdd)`- add the given Menu Item to the parent menu with the given label. If such a parent is not present, one is created.
- `unregisterMenu(JMenuItem item)`- remove given item from the menu it is in. The item will be identified by the item's ID_PROPERTY. If removing the item causes a separator to become top item of the parent menu, that separator will be removed.

### b) Windows menu entries
The DrawApplication automatically takes care that all open drawings are
added to the windows menu (and removed, respectively).  The drawings are
ordered in categories, the category is retrieved via the method `getCategory`
in the Drawing interface.

Other windows that should appear in the Windows menu must be registered
explicitly at the `CH.ifa.draw.application.WindowsMenu` instance that can be
obtained via
`DrawPlugin.getCurrent().getMenuManager().getWindowsMenu()`. 
Many tool dialogs might register themselves under the Tools category,
which is defined as a constant:
`DrawPlugin.WINDOWS_CATEGORY_TOOLS`

Public methods of the WindowsMenu object:

- `addDialog(category, dialog)` - Adds a (hopefully non-modal) dialog to the windows menu under the given category.
- `addFrame(category, frame)`- Register a window with the menu. Should be called every time a window is opened. The window title is used as menu entry.
- `removeDialog(dialog)` - Adds a frame to the windows menu under the given category.
- `removeFrame(frame)`- Deregister a window from the menu. Should be called every time a window is closed.

## Input/output

- `getIOHelper()`- the CH.ifa.draw.IOHelper Singleton collects all methods concerning the loading and saving of files; `getLoadPath(),` `loadAndOpenDrawing()`, and so on. Check its Javadoc for more information.

## Drawing Access
- `getDrawingEditor()`  - returns the drawing editor (the main window if active, or a pseudo editor object)

## Import/export
- `getImportHolder()/getExportHolder()` - returns the management classes for drawing import/export. Refer to the API Doku or source code for usage information, and put some in here once you know how it works.

## Used Properties
(For default values, see plugin.cfg)

**NAME**|**TYPE**|**Description** 
:-----|:-----|:-----
`de.renew.loadServerPort`|`int`|Interprets the value of a system property to determine if a drawing load server should be started. |
`de.renew.defaultFontSize` | `int` | Interprets the value of a system property to determine the font size for new text figures.
`de.renew.menuFontSize` | `int` | Interprets the value of a system property to determine the font size for the application menus.
`de.renew.defaultFontName` | `String` | Returns the default fontname.
`ch.ifa.draw.num-of-recent-files` | `int` | Number of drawings listed in the recently saved menu (dynamically checked)
`de.renew.windowResizable` | `boolean` | Interprets the value of a system property to determine if the main menu frame should be resizable.
`de.renew.avoidFrameReshape` | `boolean` | Interprets the value of a system property to determine if frames may be positioned or sized.
`de.renew.customToolBorders` | `boolean` | Interprets the value of a system property to determine if toolbar buttons should be painted with selfmade shadow borders.
`de.renew.noGraphics` | `boolean`| Interprets the value of a system property to determine whether graphics will be in use when loading a drawing.
`ch.ifa.draw.show-recentlysaved-hotkeys` | `boolean` | allow hotkeys for recently saved files (must be available at start-up)
`ch.ifa.draw.window-focus-workaround` | `boolean` | workaround to bring window frames to front on certain os (must be available at start-up)
`ch.ifa.draw.polygon.smoothing` | `Typ` | smoothing strategy of polygon figure (alignment (default), distances, off)
`ch.ifa.draw.grid.size` | `int` |
`ch.ifa.draw.grid.default` | `boolean` |

use upper case letters for sticky function
use Selection Tool to undo sticky function
use name of tool as suffix to define new map entries
(be careful not to use duplicate keys)
`de.renew.keymap.use-mapping`
`de.renew.keymap.Selection_Tool`
`de.renew.keymap.Transition_Tool`
`de.renew.keymap.Place_Tool`
`de.renew.keymap.Virtual_Place_Tool`
`de.renew.keymap.Test_Arc_Tool`
`de.renew.keymap.Reserve_Arc_Tool`
`de.renew.keymap.Flexible_Arc_Tool`
`de.renew.keymap.Inscription_Tool`
`de.renew.keymap.Name_Tool`|`Typ`
`de.renew.keymap.Declaration_Tool`


## Included Packages
- `CH.ifa.draw.framework`
- `CH.ifa.draw.standard`
- `CH.ifa.draw.figures`
- `CH.ifa.draw.util`
- `CH.ifa.draw`
- `CH.ifa.draw.io`
- `CH.ifa.draw.application`
- `CH.ifa.draw.io.importFormats`
- `CH.ifa.draw.io.exportFormats`
- `CH.ifa.draw.contrib`


## Provided Commands
- `CH.ifa.draw.application.CloseDrawingCommand`
- Numerous commands that implement `CH.ifa.draw.util.Command`, which can be used in conjunction with ui components.

## Public Interfaces
- `CH.ifa.draw.application.DrawingViewContainer` - view container for a drawing
- `CH.ifa.draw.application.DrawingViewContainerListener`
- `CH.ifa.draw.application.DrawingViewContainerSupplier`
- `CH.ifa.draw.contrib.OutlineFigure`
- `CH.ifa.draw.figures.LineDecoration`
- `CH.ifa.draw.figures.PolyLineable`
- `CH.ifa.draw.framework.ChildFigure`
- `CH.ifa.draw.framework.ConnectionFigure` - Figures to connect Connectors provided by Figures
- `CH.ifa.draw.framework.Connector` - connectors know how to locate a connection point on a figure
- `CH.ifa.draw.framework.Drawing` -  drawing is a container for figures 
- `CH.ifa.draw.framework.DrawingChangeListener` - listener interested in Drawing changes
- `CH.ifa.draw.framework.DrawingContext`
- `CH.ifa.draw.framework.DrawingEditor` - drawingEditor defines the interface for coordinating the different objects that participate in a drawing editor
- `CH.ifa.draw.framework.DrawingTypeManagerListener` - listeners of this type can be registered at `DrawingTypeManager` and are informed about changes in the set of known drawing types
- `CH.ifa.draw.framework.DrawingView` - drawingView renders a Drawing and listens to its changes
- `CH.ifa.draw.framework.DrawingViewDecoration` - classes implementing this interface provide some decorations which can be added to a DrawingView
- `CH.ifa.draw.framework.Figure` - the interface of a graphical figure
- `CH.ifa.draw.framework.FigureChangeListener` - listener interested in Figure changes
- `CH.ifa.draw.framework.FigureEnumeration` - interface for Enumerations that access Figures
- `CH.ifa.draw.framework.FigureFilter`
- `CH.ifa.draw.framework.FigureWithDependencies` - Tags figures which depend on other figures or are needed by other figures. The information from this interface is used to expand the selection when cut, copy or duplicate facilities are used
- `CH.ifa.draw.framework.FigureWithID` - Figures providing identification by an ID
- `CH.ifa.draw.framework.Handle` - Handles are used to change a figure by direct manipulation
- `CH.ifa.draw.framework.Locator` - Locators can be used to locate a position on a figure
- `CH.ifa.draw.framework.Painter` - Painter defines the interface for drawing a layer into a DrawingView
- `CH.ifa.draw.framework.ParentFigure`
- `CH.ifa.draw.framework.PartialSelectableFigure`
- `CH.ifa.draw.framework.PointConstrainer` - interface to constrain a Point
- `CH.ifa.draw.framework.Tool` - a tool defines a mode of the drawing view
- `CH.ifa.draw.framework.Toolbar` - a container holding toolbuttons whose tools can manipulate the data of a Drawing
- `CH.ifa.draw.io.exportFormats.ExportFormat` - this interface must be implemented to define new ExportFormats
- `CH.ifa.draw.io.exportFormats.ExportFormatMulti` - Container for ExportFormats. Is an ExportFormat itself. Can be used to arrange ExportFormats in groups
- `CH.ifa.draw.io.importFormats.ImportFormat` - this interface must be implemented to define new ImportFormats
- `CH.ifa.draw.io.importFormats.ImportFormatMulti` - Container for ImportFormats. Is an ImportFormat itself. Can be used to arrange ImportFormats in groups
- `CH.ifa.draw.io.ExportHolder` - this interface must be implemented if you want to add new ExportFormats to Renew
- `CH.ifa.draw.io.ImportHolder` - this interface must be implemented if you want to add new ImportFormats to Renew
- `CH.ifa.draw.io.StatusDisplayer`
- `CH.ifa.draw.standard.SelectionChangeListener`
- `CH.ifa.draw.standard.StringMatcher` - StringMatcher provides the interface for classes that are able to match Strings with the given search String and can also replace - in case of a match - the matching part with the
   replacement string
- `CH.ifa.draw.standard.TextHolder` - the interface of a figure that has some editable text contents
- `CH.ifa.draw.util.Animatable` - Animatable defines a simple animation interface
- `CH.ifa.draw.util.AutosaveSaver`
- `CH.ifa.draw.util.DrawingListener`
- `CH.ifa.draw.util.PaletteListener` - interface for handling palette events
- `CH.ifa.draw.util.Storable` - interface that is used by StorableInput and StorableOutput to flatten and resurrect objects