/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.minimizer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.automatalib.commons.smartcollections.DefaultLinkedList;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.IntrusiveLinkedList;
import net.automatalib.commons.smartcollections.UnorderedCollection;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.util.graphs.traversal.GraphTraversal;
import net.automatalib.util.minimizer.Block;
import net.automatalib.util.minimizer.Edge;
import net.automatalib.util.minimizer.HashMapInitialPartitioning;
import net.automatalib.util.minimizer.MinimizationResult;
import net.automatalib.util.minimizer.State;
import net.automatalib.util.minimizer.TransitionLabel;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class Minimizer<S, L> {
    private static final ThreadLocal<Minimizer<?, ?>> LOCAL_INSTANCE = ThreadLocal.withInitial(Minimizer::new);
    private final DefaultLinkedList<Block<S, L>> splitters = new DefaultLinkedList();
    private final IntrusiveLinkedList<TransitionLabel<S, L>> letterList = new IntrusiveLinkedList();
    private final IntrusiveLinkedList<State<S, L>> stateList = new IntrusiveLinkedList();
    private final IntrusiveLinkedList<Block<S, L>> splitBlocks = new IntrusiveLinkedList();
    private final IntrusiveLinkedList<Block<S, L>> newBlocks = new IntrusiveLinkedList();
    private final IntrusiveLinkedList<State<S, L>> finalList = new IntrusiveLinkedList();
    private @Nullable MutableMapping<S, @Nullable State<S, L>> stateStorage;
    private @Nullable UnorderedCollection<Block<S, L>> partition;
    private int numBlocks;

    private Minimizer() {
    }

    public static <S, L> MinimizationResult<S, L> minimize(UniversalGraph<S, ?, ?, L> graph) {
        return Minimizer.minimize(graph, graph.getNodes());
    }

    public static <S, L> MinimizationResult<S, L> minimize(UniversalGraph<S, ?, ?, L> graph, Collection<? extends S> start) {
        Minimizer<? extends S, L> minimizer = Minimizer.getLocalInstance();
        return minimizer.performMinimization(graph, start);
    }

    public static <S, L> Minimizer<S, L> getLocalInstance() {
        return LOCAL_INSTANCE.get();
    }

    public <E> MinimizationResult<S, L> performMinimization(UniversalGraph<S, E, ?, L> graph, Collection<? extends S> initialNodes) {
        Collection<Block<S, L>> initialBlocks = this.initialize(graph, initialNodes);
        this.partition = new UnorderedCollection(initialBlocks.size());
        for (Block<S, L> block : initialBlocks) {
            if (block.isEmpty()) continue;
            this.addToPartition(block);
            this.addToSplitterQueue(block);
            ++this.numBlocks;
        }
        while (!this.splitters.isEmpty()) {
            Block block = (Block)this.splitters.choose();
            this.removeFromSplitterQueue(block);
            this.split(block);
            this.updateBlocks();
        }
        MinimizationResult<S, L> result = new MinimizationResult<S, L>(this.stateStorage, this.partition);
        this.stateStorage = null;
        this.partition = null;
        this.numBlocks = 0;
        return result;
    }

    public MinimizationResult<S, L> performMinimization(UniversalGraph<S, ?, ?, L> graph) {
        return this.performMinimization(graph, graph.getNodes());
    }

    private <E> Collection<Block<S, L>> initialize(UniversalGraph<S, E, ?, L> graph, Collection<? extends S> initialNodes) {
        if (initialNodes.isEmpty()) {
            return Collections.emptyList();
        }
        Iterable<S> origStates = GraphTraversal.depthFirstOrder(graph, initialNodes);
        HashMap<Object, TransitionLabel> transitionMap = new HashMap<Object, TransitionLabel>();
        MutableMapping<N, @Nullable V> mapping = graph.createStaticNodeMapping();
        int numStates = 0;
        for (S origState : origStates) {
            State state = new State(numStates++, origState);
            mapping.put(origState, state);
            this.stateList.add(state);
        }
        HashMapInitialPartitioning initPartitioning = new HashMapInitialPartitioning(graph);
        for (State state : this.stateList) {
            Object origState = state.getOriginalState();
            Block block = initPartitioning.getBlock(origState);
            block.addState(state);
            for (Object edge : graph.getOutgoingEdges(origState)) {
                Object origTarget = graph.getTarget(edge);
                State target = (State)mapping.get(origTarget);
                Object label = graph.getEdgeProperty(edge);
                TransitionLabel transition = transitionMap.computeIfAbsent(label, TransitionLabel::new);
                Edge edgeObj = new Edge(state, target, transition);
                state.addOutgoingEdge(edgeObj);
                target.addIncomingEdge(edgeObj);
            }
        }
        this.stateList.quickClear();
        this.stateStorage = mapping;
        return initPartitioning.getInitialBlocks();
    }

    @RequiresNonNull(value={"partition"})
    private void addToPartition(Block<S, L> block) {
        ElementReference ref = this.partition.referencedAdd(block);
        block.setPartitionReference(ref);
    }

    private void addToSplitterQueue(Block<S, L> block) {
        ElementReference ref = this.splitters.referencedAdd(block);
        block.setSplitterQueueReference(ref);
    }

    private boolean removeFromSplitterQueue(Block<S, L> block) {
        ElementReference ref = block.getSplitterQueueReference();
        if (ref == null) {
            return false;
        }
        this.splitters.remove(ref);
        block.setSplitterQueueReference(null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void split(Block<S, L> splitter) {
        void var4_26;
        for (State<S, L> state : splitter.getStates()) {
            for (Edge<S, L> edge : state.getIncoming()) {
                TransitionLabel<S, L> transitionLabel = edge.getTransitionLabel();
                State<S, L> newState = edge.getSource();
                if (newState.isSingletonBlock() || !transitionLabel.addToSet(newState)) continue;
                this.letterList.add(transitionLabel);
            }
        }
        for (TransitionLabel transitionLabel : this.letterList) {
            for (State state : transitionLabel.getSet()) {
                if (!state.addToSignature(transitionLabel)) continue;
                this.stateList.add(state);
                state.setSplitPoint(false);
            }
            transitionLabel.clearSet();
        }
        this.letterList.clear();
        for (State<S, L> state : this.stateList) {
            Block<S, L> block = state.getBlock();
            if (!block.addToBucket(state)) continue;
            this.splitBlocks.add(block);
        }
        this.stateList.clear();
        for (Block block : this.splitBlocks) {
            this.stateList.concat(block.getBucket());
        }
        int i = 0;
        while (!this.stateList.isEmpty()) {
            for (State state : this.stateList) {
                TransitionLabel transitionLabel = state.getSignatureLetter(i);
                if (transitionLabel == null) {
                    this.finalList.pushBack(state);
                } else if (transitionLabel.addToBucket(state)) {
                    this.letterList.add(transitionLabel);
                }
                State state2 = (State)state.getPrev();
                if (state2 == null) {
                    state.setSplitPoint(true);
                    continue;
                }
                if (i <= 0 || state2.getSignatureLetter(i - 1) == state.getSignatureLetter(i - 1)) continue;
                state.setSplitPoint(true);
            }
            this.stateList.clear();
            for (TransitionLabel transitionLabel : this.letterList) {
                this.stateList.concat(transitionLabel.getBucket());
            }
            this.letterList.clear();
            ++i;
        }
        Object var3_14 = null;
        Object var4_25 = null;
        for (State state : this.finalList) {
            void var3_15;
            Block currBlock = state.getBlock();
            if (currBlock != var3_15) {
                currBlock.createSubBlock();
                Block block = currBlock;
            } else if (state.isSplitPoint()) {
                currBlock.createSubBlock();
            }
            currBlock.addToSubBlock(state);
            if (var4_26 != null) {
                var4_26.reset();
            }
            State state3 = state;
        }
        if (var4_26 != null) {
            var4_26.reset();
        }
        this.finalList.clear();
    }

    @RequiresNonNull(value={"partition"})
    private void updateBlocks() {
        for (Block block : this.splitBlocks) {
            int inSubBlocks = block.getElementsInSubBlocks();
            if (inSubBlocks == 0) continue;
            boolean blockRemains = inSubBlocks < block.size();
            boolean reuseBlock = !blockRemains;
            List subBlocks = block.getSubBlocks();
            if (!blockRemains && subBlocks.size() == 1) {
                block.clearSubBlocks();
                continue;
            }
            Iterator subBlockIt = subBlocks.iterator();
            if (reuseBlock) {
                UnorderedCollection first = subBlockIt.next();
                block.getStates().swap(first);
                Minimizer.updateBlockReferences(block);
            }
            while (subBlockIt.hasNext()) {
                UnorderedCollection subBlockStates = subBlockIt.next();
                if (blockRemains) {
                    for (State state : subBlockStates) {
                        block.removeState(state.getBlockReference());
                    }
                }
                Block subBlock = new Block(this.numBlocks++, subBlockStates);
                Minimizer.updateBlockReferences(subBlock);
                this.newBlocks.add(subBlock);
                this.addToPartition(subBlock);
            }
            this.newBlocks.add(block);
            block.clearSubBlocks();
            if (this.removeFromSplitterQueue(block)) {
                this.addAllToSplitterQueue(this.newBlocks);
            } else {
                this.addAllButLargest(this.newBlocks);
            }
            this.newBlocks.clear();
        }
        this.splitBlocks.clear();
    }

    private static <S, L> void updateBlockReferences(Block<S, L> block) {
        UnorderedCollection<State<S, L>> states = block.getStates();
        for (ElementReference ref : states.references()) {
            State<S, L> state = states.get(ref);
            state.setBlockReference(ref);
            state.setBlock(block);
        }
    }

    private void addAllToSplitterQueue(Collection<Block<S, L>> blocks) {
        for (Block<S, L> block : blocks) {
            this.addToSplitterQueue(block);
        }
    }

    private void addAllButLargest(Collection<Block<S, L>> blocks) {
        Block<S, L> largest = null;
        for (Block<S, L> block : blocks) {
            if (largest == null) {
                largest = block;
                continue;
            }
            if (block.size() > largest.size()) {
                this.addToSplitterQueue(largest);
                largest = block;
                continue;
            }
            this.addToSplitterQueue(block);
        }
    }
}

