/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.util.graphs.FindShortestPathsIterator;
import net.automatalib.util.graphs.Path;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ShortestPaths {
    private ShortestPaths() {
        throw new AssertionError((Object)"Constructor should not be invoked");
    }

    public static <N, E> Iterable<Path<N, E>> shortestPaths(IndefiniteGraph<N, E> graph, N start, int limit, N target) {
        return ShortestPaths.shortestPaths(graph, start, limit, (? super N n) -> Objects.equals(n, target));
    }

    public static <N, E> Iterable<Path<N, E>> shortestPaths(IndefiniteGraph<N, E> graph, N start, int limit, Predicate<? super N> targetPred) {
        return ShortestPaths.shortestPaths(graph, Collections.singleton(start), limit, targetPred);
    }

    public static <N, E> Iterable<Path<N, E>> shortestPaths(IndefiniteGraph<N, E> graph, Collection<? extends N> start, int limit, Predicate<? super N> targetPred) {
        Objects.requireNonNull(graph);
        Objects.requireNonNull(start);
        Objects.requireNonNull(targetPred);
        return () -> ShortestPaths.shortestPathsIterator(graph, start, limit, targetPred);
    }

    public static <N, E> Iterable<Path<N, E>> shortestPaths(IndefiniteGraph<N, E> graph, N start, int limit, Collection<?> targets) {
        return ShortestPaths.shortestPaths(graph, start, limit, targets::contains);
    }

    public static <N, E> Iterable<Path<N, E>> shortestPaths(IndefiniteGraph<N, E> graph, Collection<? extends N> start, int limit, N target) {
        return ShortestPaths.shortestPaths(graph, start, limit, n -> Objects.equals(n, target));
    }

    public static <N, E> Iterable<Path<N, E>> shortestPaths(IndefiniteGraph<N, E> graph, Collection<? extends N> start, int limit, Collection<?> targets) {
        return ShortestPaths.shortestPaths(graph, start, limit, targets::contains);
    }

    public static <N, E> @Nullable Path<N, E> shortestPath(IndefiniteGraph<N, E> graph, N start, int limit, Collection<?> targets) {
        return ShortestPaths.shortestPath(graph, start, limit, targets::contains);
    }

    public static <N, E> @Nullable Path<N, E> shortestPath(IndefiniteGraph<N, E> graph, N start, int limit, Predicate<? super N> targetPred) {
        return ShortestPaths.shortestPath(graph, Collections.singleton(start), limit, targetPred);
    }

    public static <N, E> @Nullable Path<N, E> shortestPath(IndefiniteGraph<N, E> graph, Collection<? extends N> start, int limit, Predicate<? super N> targetPred) {
        Iterator<Path<N, E>> spIt = ShortestPaths.shortestPathsIterator(graph, start, limit, targetPred);
        return spIt.hasNext() ? spIt.next() : null;
    }

    public static <N, E> @Nullable Path<N, E> shortestPath(IndefiniteGraph<N, E> graph, N start, int limit, N target) {
        return ShortestPaths.shortestPath(graph, start, limit, n -> Objects.equals(n, target));
    }

    public static <N, E> @Nullable Path<N, E> shortestPath(IndefiniteGraph<N, E> graph, Collection<? extends N> start, int limit, Collection<?> targets) {
        return ShortestPaths.shortestPath(graph, start, limit, targets::contains);
    }

    public static <N, E> @Nullable Path<N, E> shortestPath(IndefiniteGraph<N, E> graph, Collection<? extends N> start, int limit, N target) {
        return ShortestPaths.shortestPath(graph, start, limit, n -> Objects.equals(n, target));
    }

    public static <N, E> Iterator<Path<N, E>> shortestPathsIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start, int limit, Predicate<? super N> targetPred) {
        return new FindShortestPathsIterator<N, E>(graph, start, limit, targetPred);
    }
}

