/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.comp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.commons.util.Pair;
import net.automatalib.ts.TransitionSystem;

public class TSComposition<S1, S2, I, T1, T2, TS1 extends TransitionSystem<S1, I, T1>, TS2 extends TransitionSystem<S2, I, T2>>
implements TransitionSystem<Pair<S1, S2>, I, Pair<T1, T2>> {
    protected final TS1 ts1;
    protected final TS2 ts2;

    public TSComposition(TS1 ts1, TS2 ts2) {
        this.ts1 = ts1;
        this.ts2 = ts2;
    }

    @Override
    public Set<Pair<S1, S2>> getInitialStates() {
        Set init1 = this.ts1.getInitialStates();
        Set init2 = this.ts2.getInitialStates();
        HashSet<Pair<S1, S2>> result = new HashSet<Pair<S1, S2>>(init1.size() * init2.size());
        for (Object s1 : init1) {
            for (Object s2 : init2) {
                result.add(Pair.of(s1, s2));
            }
        }
        return result;
    }

    @Override
    public Collection<Pair<T1, T2>> getTransitions(Pair<S1, S2> state, I input) {
        S1 s1 = state.getFirst();
        S2 s2 = state.getSecond();
        Collection trans1 = this.ts1.getTransitions(s1, input);
        Collection trans2 = this.ts2.getTransitions(s2, input);
        if (trans1.isEmpty() || trans2.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<Pair<T1, T2>> result = new ArrayList<Pair<T1, T2>>(trans1.size() * trans2.size());
        for (Object t1 : trans1) {
            for (Object t2 : trans2) {
                result.add(Pair.of(t1, t2));
            }
        }
        return result;
    }

    @Override
    public Pair<S1, S2> getSuccessor(Pair<T1, T2> transition) {
        T1 t1 = transition.getFirst();
        T2 t2 = transition.getSecond();
        return Pair.of(this.ts1.getSuccessor(t1), this.ts2.getSuccessor(t2));
    }
}

