/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs.base.compact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import net.automatalib.graphs.BidirectionalGraph;
import net.automatalib.graphs.base.compact.AbstractCompactSimpleGraph;
import net.automatalib.graphs.base.compact.CompactBidiEdge;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompactSimpleBidiGraph<@Nullable EP>
extends AbstractCompactSimpleGraph<CompactBidiEdge<EP>, EP>
implements BidirectionalGraph<Integer, CompactBidiEdge<EP>> {
    private final ResizingArrayStorage<List<CompactBidiEdge<EP>>> inEdges;

    public CompactSimpleBidiGraph() {
        this.inEdges = new ResizingArrayStorage<List>(List.class);
    }

    public CompactSimpleBidiGraph(int initialCapacity) {
        super(initialCapacity);
        this.inEdges = new ResizingArrayStorage<List>(List.class, initialCapacity);
    }

    @Override
    public Collection<CompactBidiEdge<EP>> getIncomingEdges(Integer node) {
        return this.getIncomingEdges((int)node);
    }

    @Override
    public Collection<CompactBidiEdge<EP>> getIncomingEdges(int node) {
        return Collections.unmodifiableCollection(this.getInEdgeList(node));
    }

    protected List<CompactBidiEdge<EP>> getInEdgeList(int node) {
        return ((List[])this.inEdges.array)[node];
    }

    @Override
    public Integer getSource(CompactBidiEdge<EP> edge) {
        return this.getIntSource(edge);
    }

    public int getIntSource(CompactBidiEdge<EP> edge) {
        return edge.getSource();
    }

    @Override
    public int addIntNode(Void properties) {
        this.inEdges.ensureCapacity(this.size + 1);
        int node = super.addIntNode(properties);
        ((List[])this.inEdges.array)[node] = new ArrayList();
        return node;
    }

    @Override
    public CompactBidiEdge<EP> connect(int source, int target, @Nullable EP property) {
        CompactBidiEdge edge = (CompactBidiEdge)super.connect(source, target, property);
        List<CompactBidiEdge<EP>> inEdges = this.getInEdgeList(target);
        edge.inIndex = inEdges.size();
        inEdges.add(edge);
        return edge;
    }

    @Override
    protected CompactBidiEdge<EP> createEdge(int source, int target, @Nullable EP property) {
        return new CompactBidiEdge<EP>(source, target, property);
    }
}

