/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessControlException;

public class OnDiskProperties {
    private char equals = (char)61;
    private char separator = (char)58;
    private char pad = (char)95;
    private BufferedOutputStream bos;
    private String file;
    private RandomAccessFile raf;
    private int recordLength;
    private long size = -1L;

    public OnDiskProperties(String file, int recordLength, boolean write) throws FileNotFoundException {
        this.file = file;
        if (write) {
            this.bos = new BufferedOutputStream(new FileOutputStream(file));
        } else {
            try {
                if (new File(file).exists()) {
                    this.raf = new RandomAccessFile(file, "r");
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        if (recordLength < 2) {
            throw new IllegalArgumentException("OnDiskProperties: minimum recordlength is 2");
        }
        this.recordLength = recordLength + 1;
    }

    public void add(String key, String value) throws IOException {
        if (this.bos == null) {
            throw new IllegalStateException(this.getClass() + ": opened for reading");
        }
        StringBuffer record = new StringBuffer();
        record.append(key);
        record.append("=");
        record.append(value);
        record.append(this.separator);
        while (record.length() < this.recordLength - 1) {
            record.append(this.pad);
        }
        this.bos.write(record.toString().getBytes());
        this.bos.write(10);
    }

    public String getProperty(String key) throws IOException {
        int equalsIndex;
        if (this.bos != null) {
            throw new IllegalStateException(this.getClass() + ": opened for writing");
        }
        byte[] record = this.binarySearch(key.getBytes());
        if (record == null) {
            return null;
        }
        for (equalsIndex = 1; record[equalsIndex] != this.equals && equalsIndex < record.length; ++equalsIndex) {
        }
        if (equalsIndex >= record.length) {
            throw new IOException("Record without equal '" + this.equals + "' sign.");
        }
        ++equalsIndex;
        int length = 0;
        while (record[equalsIndex + length] != this.separator && equalsIndex + length < record.length) {
            ++length;
        }
        if (equalsIndex >= record.length) {
            throw new IOException("Record without separator '" + this.separator + "' sign.");
        }
        return new String(record, equalsIndex, length);
    }

    public long size() throws IOException {
        int s;
        if (this.bos != null) {
            throw new IllegalStateException(this.getClass() + ": opened for writing");
        }
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.raf != null) {
            this.size = this.raf.length() / (long)this.recordLength;
            return this.size;
        }
        BufferedInputStream bis = new BufferedInputStream(this.getClass().getResourceAsStream(this.file));
        int length = 0;
        byte[] buffer = new byte[1000000];
        while ((s = bis.read(buffer)) >= 0) {
            length += s;
        }
        bis.close();
        this.size = length / this.recordLength;
        return this.size;
    }

    public void close() throws IOException {
        if (this.bos != null) {
            this.bos.close();
        }
        if (this.raf != null) {
            this.raf.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.raf.close();
    }

    private byte[] binarySearch(byte[] name) throws IOException {
        byte[] record = new byte[this.recordLength];
        long low = 0L;
        long high = this.size() - 1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            if (this.raf != null) {
                this.raf.seek(mid * (long)this.recordLength);
                this.raf.read(record, 0, this.recordLength);
            } else {
                BufferedInputStream bis = new BufferedInputStream(this.getClass().getResourceAsStream(this.file));
                bis.skip(mid * (long)this.recordLength);
                bis.read(record, 0, this.recordLength);
                bis.close();
            }
            for (int j = 0; j < name.length; ++j) {
                if (record[j] < name[j]) {
                    low = mid + 1L;
                    break;
                }
                if (record[j] <= name[j]) continue;
                high = mid - 1L;
                break;
            }
            if (record[name.length - 1] != name[name.length - 1]) continue;
            return record;
        }
        return null;
    }
}

