/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentListener;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTabContentFilter
implements TabContentFilter {
    private List<TabContentFilterListener> listeners = new ArrayList<TabContentFilterListener>();
    protected List<StackDockStation> stations = new ArrayList<StackDockStation>();
    protected List<StackDockComponent> components = new ArrayList<StackDockComponent>();
    private DockStationListener stationListener = new DockStationAdapter(){

        public void dockableAdding(DockStation station, Dockable dockable) {
            AbstractTabContentFilter.this.added((StackDockStation)station, dockable);
        }

        public void dockableRemoved(DockStation station, Dockable dockable) {
            AbstractTabContentFilter.this.removed((StackDockStation)station, dockable);
        }

        public void dockableSelected(DockStation station, Dockable oldSelection, Dockable newSelection) {
            if (oldSelection != newSelection) {
                if (oldSelection != null) {
                    AbstractTabContentFilter.this.deselected((StackDockStation)station, oldSelection);
                }
                if (newSelection != null) {
                    AbstractTabContentFilter.this.selected((StackDockStation)station, newSelection);
                }
            }
        }
    };
    private StackDockComponentListener componentListener = new StackDockComponentListener(){

        public void tabChanged(StackDockComponent stack, Dockable dockable) {
        }

        public void selectionChanged(StackDockComponent stack) {
            AbstractTabContentFilter.this.selectionChanged(stack);
        }
    };

    public void addListener(TabContentFilterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void removeListener(TabContentFilterListener listener) {
        this.listeners.remove(listener);
    }

    protected TabContentFilterListener[] listeners() {
        return this.listeners.toArray(new TabContentFilterListener[this.listeners.size()]);
    }

    protected void fireChanged() {
        for (TabContentFilterListener listener : this.listeners()) {
            listener.contentChanged();
        }
    }

    protected void fireChanged(Dockable dockable) {
        for (TabContentFilterListener listener : this.listeners()) {
            listener.contentChanged(dockable);
        }
    }

    protected void fireChanged(StackDockStation station) {
        for (TabContentFilterListener listener : this.listeners()) {
            listener.contentChanged(station);
        }
    }

    protected void fireChanged(StackDockComponent component) {
        for (TabContentFilterListener listener : this.listeners()) {
            listener.contentChanged(component);
        }
    }

    public void install(StackDockStation station) {
        this.stations.add(station);
        station.addDockStationListener(this.stationListener);
    }

    public void install(StackDockComponent component) {
        this.components.add(component);
        component.addStackDockComponentListener(this.componentListener);
    }

    public void uninstall(StackDockStation station) {
        this.stations.remove(station);
        station.removeDockStationListener(this.stationListener);
    }

    public void uninstall(StackDockComponent component) {
        this.components.remove(component);
        component.removeStackDockComponentListener(this.componentListener);
    }

    public TabContent filter(TabContent content, StackDockStation station, Dockable dockable) {
        return content;
    }

    public TabContent filter(TabContent content, StackDockComponent component, Dockable dockable) {
        return content;
    }

    protected void added(StackDockStation station, Dockable dockable) {
    }

    protected void removed(StackDockStation station, Dockable dockable) {
    }

    protected void selected(StackDockStation station, Dockable dockable) {
    }

    protected void deselected(StackDockStation station, Dockable dockable) {
    }

    protected void selectionChanged(StackDockComponent component) {
    }
}

