/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlapDockPerspective
implements PerspectiveDockable,
PerspectiveStation {
    private PerspectiveStation parent;
    private PerspectivePlaceholderList<Item> dockables = new PerspectivePlaceholderList();
    private boolean defaultHold = false;
    private int defaultSize = 150;

    public void read(PlaceholderMap map, final Map<Integer, PerspectiveDockable> children) {
        this.dockables.read(map, new PlaceholderListItemAdapter<PerspectiveDockable, Item>(){

            @Override
            public Item convert(ConvertedPlaceholderListItem item) {
                if (children == null) {
                    return null;
                }
                int id = item.getInt("id");
                PerspectiveDockable dockable = (PerspectiveDockable)children.get(id);
                if (dockable != null) {
                    boolean hold = item.getBoolean("hold");
                    int size = item.getInt("size");
                    Item element = new Item();
                    element.dockable = dockable;
                    element.hold = hold;
                    element.size = size;
                    dockable.setParent(FlapDockPerspective.this);
                    return element;
                }
                return null;
            }
        });
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholders) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are already children present on this station");
        }
        this.dockables = new PerspectivePlaceholderList(placeholders);
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    public PlaceholderMap toMap(final Map<PerspectiveDockable, Integer> children) {
        return this.dockables.toMap(new PlaceholderListItemAdapter<PerspectiveDockable, Item>(){

            @Override
            public ConvertedPlaceholderListItem convert(int index, Item dockable) {
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                item.putInt("id", (Integer)children.get(dockable.asDockable()));
                item.putInt("index", index);
                item.putBoolean("hold", dockable.hold);
                item.putInt("size", dockable.size);
                Path placeholder = item.getPlaceholder();
                if (placeholder != null) {
                    item.putString("placeholder", placeholder.toString());
                    item.setPlaceholder(placeholder);
                }
                return item;
            }
        });
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public void setDefaultSize(int defaultSize) {
        if (defaultSize < 0) {
            throw new IllegalArgumentException("defaultSize must be at least 0: " + defaultSize);
        }
        this.defaultSize = defaultSize;
    }

    public boolean isDefaultHold() {
        return this.defaultHold;
    }

    public void setDefaultHold(boolean defaultHold) {
        this.defaultHold = defaultHold;
    }

    public void insertPlaceholder(int index, PerspectiveDockable dockable) {
        Item item = new Item();
        item.dockable = dockable;
        this.dockables.dockables().add(index, item);
        this.dockables.dockables().remove(index);
    }

    public void insertPlaceholder(int index, Path placeholder) {
        this.dockables.list().insertPlaceholder(index, placeholder);
    }

    public void addPlaceholder(PerspectiveDockable dockable) {
        this.insertPlaceholder(this.getDockableCount(), dockable);
    }

    public void addPlaceholder(Path placeholder) {
        this.insertPlaceholder(this.dockables.list().size(), placeholder);
    }

    public void add(PerspectiveDockable dockable) {
        this.add(dockable, this.defaultHold, this.defaultSize);
    }

    public void add(PerspectiveDockable dockable, boolean hold, int size) {
        this.insert(this.getDockableCount(), dockable, hold, size);
    }

    public void insert(int index, PerspectiveDockable dockable) {
        this.insert(index, dockable, this.defaultHold, this.defaultSize);
    }

    public void insert(int index, PerspectiveDockable dockable, boolean hold, int size) {
        this.insert(index, dockable, hold, size, false);
    }

    private void insert(int index, PerspectiveDockable dockable, boolean hold, int size, boolean temporary) {
        if (size < 0) {
            throw new IllegalArgumentException("size must be >= 0");
        }
        DockUtilities.ensureTreeValidity(this, dockable);
        Item item = new Item();
        item.dockable = dockable;
        item.hold = hold;
        item.size = size;
        this.dockables.dockables().add(index, item);
        dockable.setParent(this);
    }

    public PerspectiveDockable remove(int index) {
        Item item = (Item)this.dockables.dockables().get(index);
        this.dockables.remove(item);
        item.dockable.setParent(null);
        return item.dockable;
    }

    @Override
    public boolean remove(PerspectiveDockable dockable) {
        int index = this.indexOf(dockable);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public void replace(PerspectiveDockable oldDockable, PerspectiveDockable newDockable) {
        int index = this.indexOf(oldDockable);
        if (index < 0) {
            throw new IllegalArgumentException("oldDockable is not a child of this station");
        }
        DockUtilities.ensureTreeValidity(this, newDockable);
        boolean hold = this.isHold(oldDockable);
        int size = this.getSize(oldDockable);
        this.remove(index);
        this.insert(index, newDockable, hold, size);
    }

    public int indexOf(PerspectiveDockable dockable) {
        int count = 0;
        for (Item item : this.dockables.dockables()) {
            if (item.asDockable() == dockable) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    public void setHold(PerspectiveDockable dockable, boolean hold) {
        this.item((PerspectiveDockable)dockable).hold = hold;
    }

    public boolean isHold(PerspectiveDockable dockable) {
        return this.item((PerspectiveDockable)dockable).hold;
    }

    public void setSize(PerspectiveDockable dockable, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size must be >= 0: " + size);
        }
        this.item((PerspectiveDockable)dockable).size = size;
    }

    public int getSize(PerspectiveDockable dockable) {
        return this.item((PerspectiveDockable)dockable).size;
    }

    @Override
    public DockableProperty getDockableProperty(PerspectiveDockable child, PerspectiveDockable target) {
        int index = this.indexOf(child);
        boolean hold = this.isHold(child);
        int size = this.getSize(child);
        Path placeholder = null;
        placeholder = target != null ? target.getPlaceholder() : child.getPlaceholder();
        return new FlapDockProperty(index, hold, size, placeholder);
    }

    private Item item(PerspectiveDockable dockable) {
        int index = this.indexOf(dockable);
        if (index < 0) {
            throw new IllegalArgumentException("not a child of this station: " + dockable);
        }
        return (Item)this.dockables.dockables().get(index);
    }

    @Override
    public void setParent(PerspectiveStation parent) {
        this.parent = parent;
    }

    @Override
    public PerspectiveStation getParent() {
        return this.parent;
    }

    @Override
    public Path getPlaceholder() {
        return null;
    }

    @Override
    public PerspectiveDockable asDockable() {
        return this;
    }

    @Override
    public PerspectiveStation asStation() {
        return this;
    }

    @Override
    public String getFactoryID() {
        return "flap dock";
    }

    @Override
    public PerspectiveDockable getDockable(int index) {
        return ((Item)this.dockables.dockables().get((int)index)).dockable;
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Item
    implements PlaceholderListItem<PerspectiveDockable> {
        public PerspectiveDockable dockable;
        public boolean hold;
        public int size;

        private Item() {
        }

        @Override
        public PerspectiveDockable asDockable() {
            return this.dockable;
        }
    }
}

