/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.themes.ThemeDockableMovingImageFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import java.util.List;

public class DefaultDockableMovingImageFactory
implements DockableMovingImageFactory {
    public static final Path FACTORY_EXTENSION = new Path("dock.movingImageFactory");
    private DockableMovingImageFactory delegate;
    private List<DockableMovingImageFactory> extensions;

    public DefaultDockableMovingImageFactory(DockController controller) {
        this(controller, new ThemeDockableMovingImageFactory());
    }

    public DefaultDockableMovingImageFactory(DockController controller, DockableMovingImageFactory delegate) {
        this.extensions = controller.getExtensions().load(new ExtensionName<DockableMovingImageFactory>(FACTORY_EXTENSION, DockableMovingImageFactory.class));
        this.delegate = delegate;
    }

    public MovingImage create(DockController controller, Dockable dockable) {
        for (DockableMovingImageFactory factory : this.extensions) {
            MovingImage image = factory.create(controller, dockable);
            if (image == null) continue;
            return image;
        }
        return this.delegate.create(controller, dockable);
    }

    public MovingImage create(DockController controller, DockTitle snatched) {
        for (DockableMovingImageFactory factory : this.extensions) {
            MovingImage image = factory.create(controller, snatched);
            if (image == null) continue;
            return image;
        }
        return this.delegate.create(controller, snatched);
    }
}

