/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationHistory {
    private Map<ExtendedMode, Location> locations = new HashMap<ExtendedMode, Location>();
    private List<ExtendedMode> order = new LinkedList<ExtendedMode>();

    public void add(ExtendedMode mode, Location location) {
        if (!mode.getModeIdentifier().equals(location.getMode())) {
            throw new IllegalArgumentException("mode and location do not fit together");
        }
        this.locations.put(mode, location);
        this.order.remove(mode);
        this.order.add(mode);
    }

    public void insert(int index, ExtendedMode mode, Location location) {
        if (!mode.getModeIdentifier().equals(location.getMode())) {
            throw new IllegalArgumentException("mode and location do not fit together");
        }
        this.locations.put(mode, location);
        int old = this.order.indexOf(mode);
        if (old > 0) {
            if (old < index) {
                --index;
            }
            this.order.remove(old);
        }
        this.order.add(index, mode);
    }

    public Location get(ExtendedMode mode) {
        return this.locations.get(mode);
    }

    public void remove(ExtendedMode mode) {
        this.locations.remove(mode);
        this.order.remove(mode);
    }

    public int getSize() {
        return this.order.size();
    }

    public ExtendedMode getMode(int index) {
        return this.order.get(index);
    }

    public ExtendedMode getLastMode() {
        int size = this.getSize();
        if (size == 0) {
            return null;
        }
        return this.getMode(size - 1);
    }

    public List<Path> getOrder() {
        ArrayList<Path> result = new ArrayList<Path>();
        for (ExtendedMode mode : this.order) {
            result.add(mode.getModeIdentifier());
        }
        return result;
    }

    public Map<Path, Location> getLocations() {
        HashMap<Path, Location> result = new HashMap<Path, Location>();
        for (Location location : this.locations.values()) {
            result.put(location.getMode(), location);
        }
        return result;
    }
}

