/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStationLayout;
import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonDockStationPerspective;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonDockStationFactory
implements DockFactory<CommonDockStation<?, ?>, CommonDockStationPerspective, CommonDockStationLayout> {
    public static final String FACTORY_ID = "CommonDockStationFactory";
    private CControl control;
    private CommonSingleDockableFactory singleDockableFactory;
    private FrontendPerspectiveCache cache;

    public CommonDockStationFactory(CControl control, FrontendPerspectiveCache cache, CommonSingleDockableFactory singleDockableFactory) {
        if (control == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        if (singleDockableFactory == null) {
            throw new IllegalArgumentException("singleDockableFactory must not be null");
        }
        this.control = control;
        this.cache = cache;
        this.singleDockableFactory = singleDockableFactory;
    }

    protected CommonDockStation<?, ?> createStation(String id) {
        SingleCDockableFactory factory = this.singleDockableFactory.getFactory(id);
        if (factory == null) {
            return null;
        }
        SingleCDockable dockable = factory.createBackup(id);
        if (dockable == null) {
            return null;
        }
        String factoryId = dockable.intern().getFactoryID();
        if (!factoryId.equals(this.getID())) {
            throw new IllegalArgumentException("Wrong type of dockable for unique id '" + id + "': The backup factory created a dockable which expects a factory of type '" + factoryId + "',  but the call was done from a factory of type '" + this.getID() + "'");
        }
        CStation<?> station = dockable.asStation();
        if (station == null) {
            System.err.println("unique identifier '" + id + "' was supposed to be a CStation, but factory created a dockable");
            return null;
        }
        return station.getStation();
    }

    protected void registerStation(CStation<?> station, boolean root) {
        SingleCDockable single;
        CDockable dockable;
        if (this.control.getStation(station.getUniqueId()) != station) {
            this.control.addStation(station, root);
        }
        if ((dockable = station.asDockable()) != null && dockable instanceof SingleCDockable && this.control.getSingleDockable((single = (SingleCDockable)dockable).getUniqueId()) != single) {
            this.control.addDockable(single);
        }
    }

    @Override
    public String getID() {
        return FACTORY_ID;
    }

    @Override
    public CommonDockStationLayout getLayout(CommonDockStation<?, ?> element, Map<Dockable, Integer> children) {
        String factoryId = element.getConverterID();
        DockFactory<?, ?, ?> factory = this.control.intern().getDockFactory(factoryId);
        if (factory == null) {
            return null;
        }
        Object layout = factory.getLayout(element, children);
        if (layout == null) {
            return null;
        }
        CDockable dockable = element.getStation().asDockable();
        String id = null;
        if (dockable instanceof SingleCDockable) {
            id = ((SingleCDockable)dockable).getUniqueId();
        }
        boolean root = this.control.isRootStation(element.getStation());
        return new CommonDockStationLayout(id, root, factoryId, new DockLayout(factoryId, layout));
    }

    @Override
    public CommonDockStation<?, ?> layout(CommonDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        CommonDockStation<?, ?> station = this.createStation(layout.getId());
        if (station == null) {
            return null;
        }
        this.registerStation(station.getStation(), layout.isRoot());
        this.setLayout(station, layout, children, placeholders);
        return station;
    }

    @Override
    public CommonDockStation<?, ?> layout(CommonDockStationLayout layout, PlaceholderStrategy placeholders) {
        return this.layout(layout, (Map<Integer, Dockable>)null, placeholders);
    }

    @Override
    public void setLayout(CommonDockStation<?, ?> element, CommonDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        String factoryId = element.getConverterID();
        DockFactory<?, ?, ?> factory = this.control.intern().getDockFactory(factoryId);
        if (factory == null) {
            return;
        }
        layout.updateLayout(factory, placeholders);
        DockLayout<?> data = layout.getLayout();
        if (data == null) {
            return;
        }
        if (children == null) {
            factory.setLayout(element, data.getData(), placeholders);
        } else {
            factory.setLayout(element, data.getData(), children, placeholders);
        }
    }

    @Override
    public void setLayout(CommonDockStation<?, ?> element, CommonDockStationLayout layout, PlaceholderStrategy placeholders) {
        this.setLayout(element, layout, (Map<Integer, Dockable>)null, placeholders);
    }

    @Override
    public void estimateLocations(CommonDockStationLayout layout, LocationEstimationMap children) {
        String factoryId = null;
        if (layout != null) {
            factoryId = layout.getFactoryId();
        }
        if (factoryId == null) {
            return;
        }
        DockFactory<?, ?, ?> factory = this.control.intern().getDockFactory(factoryId);
        if (factory == null) {
            return;
        }
        layout.updateLayout(factory, null);
        DockLayout<?> data = layout.getLayout();
        if (data == null) {
            return;
        }
        factory.estimateLocations(data.getData(), children);
    }

    @Override
    public CommonDockStationPerspective layoutPerspective(CommonDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        CommonDockStationPerspective element = null;
        if (this.cache != null) {
            element = (CommonDockStationPerspective)this.cache.get(layout.getId(), layout.isRoot());
        }
        if (element == null) {
            return null;
        }
        this.layoutPerspective(element, layout, children);
        return element;
    }

    @Override
    public void layoutPerspective(CommonDockStationPerspective element, CommonDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        CStationPerspective station = element.getElement().asStation();
        station.setRoot(layout.isRoot());
        DockFactory<?, ?, ?> factory = this.control.intern().getDockFactory(layout.getFactoryId());
        if (factory == null) {
            return;
        }
        layout.updateLayout(factory, null);
        DockLayout<?> data = layout.getLayout();
        if (data == null) {
            return;
        }
        factory.layoutPerspective(element, data.getData(), children);
    }

    @Override
    public CommonDockStationLayout getPerspectiveLayout(CommonDockStationPerspective element, Map<PerspectiveDockable, Integer> children) {
        String factoryId = element.getConverterID();
        DockFactory<?, ?, ?> dockFactory = this.control.intern().getDockFactory(factoryId);
        DockFactory<?, ?, ?> factory = dockFactory;
        if (factory == null) {
            return null;
        }
        Object data = factory.getPerspectiveLayout(element, children);
        if (data == null) {
            return null;
        }
        CElementPerspective celement = element.getElement();
        CStationPerspective station = celement.asStation();
        String id = station.getUniqueId();
        return new CommonDockStationLayout(id, station.isRoot(), factoryId, new DockLayout(factoryId, data));
    }

    @Override
    public void write(CommonDockStationLayout layout, XElement element) {
        String id;
        String factoryId = layout.getFactoryId();
        DockFactory<?, ?, ?> factory = this.control.intern().getDockFactory(factoryId);
        XElement content = layout.getLayoutXML();
        if (content == null) {
            layout.updateLayout(factory, null);
            DockLayout<?> data = layout.getLayout();
            if (data == null) {
                throw new XException("data are null, but data were just updated");
            }
            content = new XElement("content");
            factory.write(data.getData(), content);
        }
        if ((id = layout.getId()) != null) {
            element.addElement("id").setString(id);
        }
        element.addElement("root").setBoolean(layout.isRoot());
        content.addString("delegate", factoryId);
        element.addElement(content);
    }

    @Override
    public CommonDockStationLayout read(XElement element, PlaceholderStrategy placeholders) {
        String id = null;
        XElement xid = element.getElement("id");
        if (xid != null) {
            id = xid.getString();
        }
        boolean root = element.getElement("root").getBoolean();
        XElement xcontent = element.getElement("content");
        if (xcontent == null) {
            throw new XException("missing content element");
        }
        String factoryId = xcontent.getString("delegate");
        DockFactory<?, ?, ?> factory = this.control.intern().getDockFactory(factoryId);
        if (factory == null) {
            return new CommonDockStationLayout(id, root, factoryId, xcontent);
        }
        Object data = factory.read(xcontent, placeholders);
        if (data == null) {
            return null;
        }
        return new CommonDockStationLayout(id, root, factoryId, new DockLayout(factoryId, data));
    }

    @Override
    public void write(CommonDockStationLayout layout, DataOutputStream out) throws IOException {
        String factoryId = layout.getFactoryId();
        DockFactory<?, ?, ?> factory = this.control.intern().getDockFactory(factoryId);
        byte[] content = layout.getLayoutBytes();
        if (content == null) {
            layout.updateLayout(factory, null);
            DockLayout<?> data = layout.getLayout();
            if (data == null) {
                throw new IOException("data are null, but data were just updated");
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            factory.write(data.getData(), new DataOutputStream(bout));
            content = bout.toByteArray();
        }
        if (content == null) {
            throw new IOException("unable to write layout, it could not be converted into byte-array format");
        }
        Version.write(out, Version.VERSION_1_1_1);
        String id = layout.getId();
        if (id == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(id);
        }
        out.writeBoolean(layout.isRoot());
        out.writeUTF(factoryId);
        out.writeInt(content.length);
        out.write(content);
    }

    @Override
    public CommonDockStationLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        int delta;
        Version.read(in).checkCurrent();
        String id = in.readBoolean() ? in.readUTF() : null;
        boolean root = in.readBoolean();
        String factoryId = in.readUTF();
        int length = in.readInt();
        byte[] content = new byte[length];
        for (int offset = 0; offset < length; offset += delta) {
            delta = in.read(content, offset, length - offset);
            if (delta != -1) continue;
            throw new EOFException();
        }
        DockFactory<?, ?, ?> factory = this.control.intern().getDockFactory(factoryId);
        if (factory == null) {
            return new CommonDockStationLayout(id, root, factoryId, content);
        }
        Object data = factory.read(new DataInputStream(new ByteArrayInputStream(content)), placeholders);
        if (data == null) {
            return null;
        }
        return new CommonDockStationLayout(id, root, factoryId, new DockLayout(factoryId, data));
    }
}

