/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootStationAdjacentFactory
implements AdjacentDockFactory<Path> {
    public static final String FACTORY_ID = "dock.RootStationAdjacentFactory";

    @Override
    public boolean interested(DockElement element) {
        return element instanceof CommonDockStation;
    }

    @Override
    public boolean interested(PerspectiveElement element) {
        if (element instanceof CommonElementPerspective) {
            CStationPerspective station = ((CommonElementPerspective)element).getElement().asStation();
            return station != null;
        }
        return false;
    }

    @Override
    public String getID() {
        return FACTORY_ID;
    }

    @Override
    public Path getLayout(DockElement element, Map<Dockable, Integer> children) {
        return ((CommonDockStation)element).getStation().getTypeId();
    }

    @Override
    public Path getPerspectiveLayout(PerspectiveElement element, Map<PerspectiveDockable, Integer> children) {
        CStationPerspective station = ((CommonElementPerspective)element).getElement().asStation();
        return station.getTypeId();
    }

    @Override
    public Path read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        byte version = in.readByte();
        if (version != 0) {
            throw new IOException("unknown version: " + version);
        }
        if (in.readBoolean()) {
            return new Path(in.readUTF());
        }
        return null;
    }

    @Override
    public Path read(XElement element, PlaceholderStrategy placeholders) {
        XElement xtype = element.getElement("type");
        if (xtype == null) {
            return null;
        }
        return new Path(xtype.getString());
    }

    @Override
    public void setLayout(DockElement element, Path layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        if (!(element instanceof CommonDockStation)) {
            throw new IllegalArgumentException("expected the 'element' to be a '" + CommonDockStation.class.getSimpleName() + "', but instead it was a '" + element.getClass().getName() + "'.\n" + "The reason for this exception may be be:\n - a DockElement that was registered with the wrong unique identifier\n - the type of a DockElement was changed\n - a SingleCDockableFactory creating the wrong type of items.\n" + "Type and toString of 'element': " + element.getClass().getName() + ",\n" + element);
        }
        CStation station = ((CommonDockStation)element).getStation();
        Path typeId = station.getTypeId();
        if (typeId != null && !typeId.equals(layout)) {
            throw new IllegalArgumentException("expected the 'element' to have type id '" + layout + "', but instead it was '" + typeId + "'.\n" + "The reason for this exception may be be:\n - a DockElement that was registered with the wrong unique identifier\n - the type of a DockElement was changed\n - a SingleCDockableFactory creating the wrong type of items.\n" + "Type and toString of 'element': " + station.getClass().getName() + ",\n" + station);
        }
    }

    @Override
    public void setLayout(DockElement element, Path layout, PlaceholderStrategy placeholders) {
        this.setLayout(element, layout, (Map<Integer, Dockable>)null, placeholders);
    }

    @Override
    public void write(Path layout, DataOutputStream out) throws IOException {
        out.writeByte(0);
        if (layout == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(layout.toString());
        }
    }

    @Override
    public void write(Path layout, XElement element) {
        if (layout != null) {
            element.addElement("type").setString(layout.toString());
        }
    }
}

