/*
 * Decompiled with CFR 0.152.
 */
package de.renew.console.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import jline.console.completer.Completer;
import jline.internal.Preconditions;

public class CompleterComposition
implements Completer {
    private final List<Completer> _completers = new ArrayList<Completer>();

    public CompleterComposition() {
    }

    public CompleterComposition(Collection<Completer> completers) {
        Preconditions.checkNotNull(completers);
        this._completers.addAll(completers);
    }

    public CompleterComposition(Completer ... completers) {
        this(Arrays.asList(completers));
    }

    public Collection<Completer> getCompleters() {
        return this._completers;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        Preconditions.checkNotNull(candidates);
        ArrayList<Completion> completions = new ArrayList<Completion>(this._completers.size());
        int max = -1;
        for (Completer completer : this._completers) {
            Completion completion = new Completion(candidates);
            completion.complete(completer, buffer, cursor);
            max = Math.max(max, completion.getCursor());
            completions.add(completion);
        }
        for (Completion completion : completions) {
            if (completion.getCursor() != max) continue;
            candidates.addAll(completion.getCandidates());
        }
        return max;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{completers=" + String.valueOf(this._completers) + "}";
    }

    public void addCompleter(Completer completer) {
        this._completers.add(completer);
    }

    public void removeCompleter(Completer completer) {
        this._completers.remove(completer);
    }

    private class Completion {
        private final List<CharSequence> _candidates;
        private int _cursor;

        Completion(List<CharSequence> candidates) {
            Preconditions.checkNotNull(candidates);
            this._candidates = new LinkedList<CharSequence>(candidates);
        }

        public List<CharSequence> getCandidates() {
            return this._candidates;
        }

        public int getCursor() {
            return this._cursor;
        }

        public void complete(Completer completer, String buffer, int cursor) {
            Preconditions.checkNotNull((Object)completer);
            this._cursor = completer.complete(buffer, cursor, this._candidates);
        }
    }
}

