/*
 * Decompiled with CFR 0.152.
 */
package de.renew.console;

import de.renew.console.completer.CompleterComposition;
import de.renew.console.completer.DrawingsCompleter;
import de.renew.console.completer.FirstWhitespaceArgumentDelimiter;
import de.renew.console.completer.LocationsCompleter;
import de.renew.console.completer.PluginCompleter;
import de.renew.console.completer.PropertyCompleter;
import de.renew.console.completer.RenewArgumentCompleter;
import de.renew.plugin.CommandsListener;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.SoftDependency;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.command.InteractiveCLCommand;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import jline.console.ConsoleReader;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.CandidateListCompletionHandler;
import jline.console.completer.Completer;
import jline.console.completer.CompletionHandler;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.log4j.Logger;

public class ConsolePlugin
extends PluginAdapter
implements CommandsListener {
    private static final String COLOR_PROP_NAME = "de.renew.console.color";
    private static final String DRAWING_NAMES = "drawingNames";
    private static final String PROPERTY_NAMES = "propertyNames";
    private static final String LOCATION_NAMES = "locationNames";
    private static final String PLUGIN_NAMES = "pluginNames";
    private static final String FILE_NAMES = "fileNames";
    private static final Logger LOGGER = Logger.getLogger(ConsolePlugin.class);
    private static final String KEEPALIVE = "keepalive";
    private static final String PROMPT_ALIVE = "Prompt will keep plugin system alive.";
    private static final String PROMPT_NOT_ALIVE = "Prompt will not prevent plugin system from automatic termination.";
    private static final String DONT_PROP_NAME = "de.renew.console.dont";
    private static final String ALIVE_PROP_NAME = "de.renew.console.keepalive";
    private boolean _coloredPrompt = false;
    private PromptThread _promptThread;
    private boolean _blockingState = false;
    private Map<String, Completer> _completers = new HashMap<String, Completer>();
    private CountDownLatch _latch;
    private boolean _promtThreadReady = false;
    private SoftDependency _chDependency;

    public ConsolePlugin(URL url) throws PluginException {
        super(url);
    }

    public ConsolePlugin(PluginProperties props) {
        super(props);
    }

    public synchronized void init() {
        boolean startPrompt;
        boolean bl = startPrompt = !this.getProperties().getBoolProperty(DONT_PROP_NAME);
        if (startPrompt) {
            this._latch = new CountDownLatch(1);
            this.prompt();
            this.setBlockingState(this.getProperties().getBoolProperty(ALIVE_PROP_NAME));
            PluginManager pm = PluginManager.getInstance();
            pm.addCommandListener((CommandsListener)this);
            this._coloredPrompt = this.getProperties().getBoolProperty(COLOR_PROP_NAME);
            for (Map.Entry entry : pm.getCLCommands().entrySet()) {
                String commandName = (String)entry.getKey();
                CLCommand command = (CLCommand)entry.getValue();
                this.commandAdded(commandName, command);
            }
            pm.addCLCommand(KEEPALIVE, (CLCommand)new BlockingPromptCommand());
        } else {
            LOGGER.debug((Object)"ConsolePlugin: de.renew.console.dont is set to true. Not prompting.");
        }
        this._chDependency = new SoftDependency((IPlugin)this, "ch.ifa.draw", "de.renew.console.CHDependencyListener");
    }

    public synchronized boolean cleanup() {
        if (this._promptThread != null) {
            LOGGER.debug((Object)("shutting down prompt thread " + String.valueOf(this._promptThread)));
            this._promptThread.setStop();
            PluginManager.getInstance().removeCLCommand(KEEPALIVE);
            this._promptThread = null;
        }
        PluginManager pm = PluginManager.getInstance();
        pm.removeCLCommand(KEEPALIVE);
        pm.removeCLCommand("reinit");
        pm.removeCommandListener((CommandsListener)this);
        if (this._chDependency != null) {
            this._chDependency.discard();
            this._chDependency = null;
        }
        return true;
    }

    private void prompt() {
        this._promptThread = new PromptThread();
        this._promptThread.start();
    }

    public synchronized void setBlockingState(boolean newState) {
        if (newState != this._blockingState) {
            this._blockingState = newState;
            if (this._blockingState) {
                this.registerExitBlock();
            } else {
                this.registerExitOk();
            }
        }
    }

    public void commandAdded(String name, CLCommand command) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[" + ConsolePlugin.class.getSimpleName() + "]: Command added: " + name + " " + command.getClass().getSimpleName()));
        }
        String arguments = command.getArguments();
        String[] argumentsArray = null;
        if (arguments != null) {
            argumentsArray = arguments.replaceAll(" +", " ").split(" ");
        }
        Completer completer = this.getCompleterForCommand(name, argumentsArray);
        if (!this._promtThreadReady) {
            try {
                LOGGER.debug((Object)("[" + ConsolePlugin.class.getSimpleName() + "]: Waiting for Prompt thread."));
                this._latch.await();
                this._promtThreadReady = true;
                LOGGER.debug((Object)("[" + ConsolePlugin.class.getSimpleName() + "]: Prompt thread ready."));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._promptThread._ac.addCompleter(completer);
        this._completers.put(name, completer);
    }

    public void commandRemoved(String name) {
        if (this._promptThread != null && this._promptThread._ac != null) {
            this._promptThread._ac.removeCompleter(this._completers.remove(name));
        }
    }

    private Completer getCompleterForCommand(String commandName, String[] arguments) {
        NullCompleter completer = new NullCompleter();
        if (arguments != null) {
            NullCompleter followUpCompleter = new NullCompleter();
            for (int i = arguments.length - 1; i >= 0; --i) {
                String arg = arguments[i];
                Completer completerForArgument = this.getArgumentCompleter(arg);
                followUpCompleter = completer = this.handleArgumentCompleter(arg, completerForArgument, (Completer)followUpCompleter);
            }
        }
        return new RenewArgumentCompleter((RenewArgumentCompleter.ArgumentDelimiter)new FirstWhitespaceArgumentDelimiter(), new Completer[]{new StringsCompleter(new String[]{commandName + " "}), completer});
    }

    private Completer getArgumentCompleter(String arg) {
        if (this.isOptionalOrAlternative(arg)) {
            return this.createComplexArgumentCompleter(arg);
        }
        if (this.isKeyword(arg)) {
            return this.getCompleterForKeyword(arg);
        }
        return new StringsCompleter(new String[]{arg + " "});
    }

    private boolean isOptionalOrAlternative(String arg) {
        return arg.matches("\\[.*\\]\\*?") || arg.matches("\\(.*\\)\\*?");
    }

    private Completer createComplexArgumentCompleter(String arg) {
        boolean loop = arg.matches(".*\\*");
        arg = arg.replaceAll("^[\\[\\(]|[\\]\\)]\\*$", "");
        String[] argSplit = arg.split("\\|");
        ArrayList<CallSite> strings = new ArrayList<CallSite>();
        ArrayList<Completer> completers = new ArrayList<Completer>();
        for (String s : argSplit) {
            if (this.isKeyword(s)) {
                completers.add(this.getCompleterForKeyword(s));
                continue;
            }
            strings.add((CallSite)((Object)(s + " ")));
        }
        if (!strings.isEmpty()) {
            completers.add((Completer)new StringsCompleter(strings));
        }
        CompleterComposition completerForArgument = new CompleterComposition(completers);
        if (loop) {
            return this.createLoopingCompleter(completerForArgument);
        }
        return completerForArgument;
    }

    private Completer createLoopingCompleter(Completer completerForArgument) {
        CompleterComposition followUpCompleterWithBackwardsOption = new CompleterComposition(new Completer[]{new NullCompleter()});
        return new RenewArgumentCompleter((RenewArgumentCompleter.ArgumentDelimiter)new FirstWhitespaceArgumentDelimiter(), completerForArgument, followUpCompleterWithBackwardsOption);
    }

    private Completer handleArgumentCompleter(String arg, Completer completerForArgument, Completer followUpCompleter) {
        boolean optional = arg.matches("\\[.*\\]\\*?");
        boolean loop = arg.matches(".*\\*");
        if (loop) {
            return new RenewArgumentCompleter((RenewArgumentCompleter.ArgumentDelimiter)new FirstWhitespaceArgumentDelimiter(), completerForArgument, followUpCompleter);
        }
        if (optional) {
            return new AggregateCompleter(new Completer[]{completerForArgument, followUpCompleter});
        }
        return new RenewArgumentCompleter((RenewArgumentCompleter.ArgumentDelimiter)new FirstWhitespaceArgumentDelimiter(), completerForArgument, followUpCompleter);
    }

    private Completer getCompleterForKeyword(String keyword) {
        Object result = keyword.equals(FILE_NAMES) ? new FileNameCompleter() : (keyword.equals(PLUGIN_NAMES) ? new PluginCompleter() : (keyword.equals(LOCATION_NAMES) ? new LocationsCompleter() : (keyword.equals(PROPERTY_NAMES) ? new PropertyCompleter() : (keyword.equals(DRAWING_NAMES) ? new DrawingsCompleter() : new NullCompleter()))));
        return result;
    }

    private boolean isKeyword(String candidate) {
        return Arrays.asList(FILE_NAMES, PLUGIN_NAMES, LOCATION_NAMES, PROPERTY_NAMES, DRAWING_NAMES).contains(candidate);
    }

    private class BlockingPromptCommand
    implements CLCommand {
        private BlockingPromptCommand() {
        }

        public void execute(String[] args, PrintStream response) {
            if (args.length == 0) {
                if (ConsolePlugin.this._blockingState) {
                    response.println(ConsolePlugin.PROMPT_ALIVE);
                } else {
                    response.println(ConsolePlugin.PROMPT_NOT_ALIVE);
                }
            } else if ("on".equals(args[0])) {
                ConsolePlugin.this.setBlockingState(true);
                response.println(ConsolePlugin.PROMPT_ALIVE);
            } else if ("off".equals(args[0])) {
                ConsolePlugin.this.setBlockingState(false);
                response.println(ConsolePlugin.PROMPT_NOT_ALIVE);
            } else {
                response.println("Controls the keep-alive feature of the Renew Prompt plugin.\nArguments:\n - \"on\" prevents the plugin system from automatic termination.\n - \"off\" allows automatic termination as long as no other plugin prevents it.\n - no argument displays the current keep-alive mode.");
            }
        }

        public String getDescription() {
            return "controls the keep-alive feature of the Renew Prompt plugin.";
        }

        public String getArguments() {
            return null;
        }
    }

    private class PromptThread
    extends Thread {
        private static final String HISTORY_PROPS = "history.props";
        private boolean _stop;
        private ConsoleReader _reader;
        private File _prefsFile;
        private CompleterComposition _ac;

        PromptThread() {
            super("Plugin-Prompt-Thread");
            this._stop = false;
            this._prefsFile = null;
            this._ac = new CompleterComposition();
            File dotRenew = PluginManager.getPreferencesLocation();
            this._prefsFile = new File(dotRenew, HISTORY_PROPS);
        }

        @Override
        public void run() {
            LOGGER.debug((Object)"Prompt thread running.");
            this._stop = false;
            try {
                this.initializeReader();
                this.handleUserInput();
            }
            catch (ThreadDeath death) {
                LOGGER.debug((Object)"Prompt thread exiting!");
            }
            catch (IOException e) {
                this.handleIOException(e);
            }
            this.cleanup();
        }

        private void initializeReader() throws IOException {
            this._reader = new ConsoleReader();
            CompletionHandler completionHandler = this._reader.getCompletionHandler();
            if (completionHandler instanceof CandidateListCompletionHandler) {
                ((CandidateListCompletionHandler)completionHandler).setPrintSpaceAfterFullCompletion(false);
            }
            this._reader.setPrompt(this.getPrompt());
            FileHistory history = new FileHistory(this._prefsFile);
            this._reader.setHistory((History)history);
            this._reader.addCompleter((Completer)this._ac);
            ConsolePlugin.this._latch.countDown();
        }

        private void handleUserInput() {
            PrintWriter out = new PrintWriter(this._reader.getOutput());
            try {
                String line = this._reader.readLine();
                while (!this._stop && line != null) {
                    this.processLine(out, line);
                    line = this.readNextLine();
                }
            }
            catch (IOException | IllegalArgumentException e) {
                this.handleInputException(e);
            }
        }

        private void processLine(PrintWriter out, String line) {
            if (LOGGER.isDebugEnabled()) {
                this.logLine(line);
            }
            out.flush();
            this.executeCommands(line);
        }

        private void executeCommands(String line) {
            try {
                String[] cmds;
                Map commands = PluginManager.getInstance().getCLCommands();
                for (String cmd : cmds = line.split("---")) {
                    this.executeCommand(commands, cmd);
                }
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("PromptThread: an exception occurred: " + String.valueOf(e)));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        private void executeCommand(Map<String, CLCommand> commands, String cmd) {
            String[] cl = StringUtil.splitStringWithEscape((String)(cmd = cmd.trim()));
            if (cl.length == 0) {
                return;
            }
            CLCommand c = commands.get(cl[0]);
            if (c == null) {
                System.out.println("unknown command.");
            } else {
                String[] nc = Arrays.copyOfRange(cl, 1, cl.length);
                if (c instanceof InteractiveCLCommand) {
                    InteractiveCLCommand ic = (InteractiveCLCommand)c;
                    ic.execute(nc, System.out, this::readAdditionalUserInput);
                } else {
                    c.execute(nc, System.out);
                }
            }
        }

        private String readNextLine() {
            try {
                this._reader.getTerminal().init();
                return this._reader.readLine();
            }
            catch (Exception e) {
                this.handleInputException(e);
                return null;
            }
        }

        private void handleInputException(Exception e) {
            LOGGER.error((Object)("Error reading input: " + e.getMessage()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Exception: ", (Throwable)e);
            }
        }

        private void handleIOException(IOException e) {
            LOGGER.error((Object)e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(PromptThread.class.getSimpleName() + ": " + String.valueOf(e)));
            }
        }

        private void logLine(String line) {
            if (ConsolePlugin.this._coloredPrompt) {
                LOGGER.debug((Object)("\u001b[33m=>\u001b[0m\"" + line + "\""));
            } else {
                LOGGER.debug((Object)("=>\"" + line + "\""));
            }
        }

        private void cleanup() {
            ConsolePlugin.this.setBlockingState(false);
            System.out.println("exiting 3");
        }

        private String readAdditionalUserInput() throws IOException {
            try (ConsoleReader reader = new ConsoleReader();){
                String string = reader.readLine();
                return string;
            }
        }

        private String getPrompt() {
            if (ConsolePlugin.this._coloredPrompt) {
                return "\u001b[34mRenew > \u001b[0m";
            }
            return "Renew > ";
        }

        protected void setStop() {
            block2: {
                FileHistory history = (FileHistory)this._reader.getHistory();
                try {
                    history.flush();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage());
                    if (!LOGGER.isDebugEnabled()) break block2;
                    LOGGER.debug((Object)(PromptThread.class.getSimpleName() + ": could not save prompt history" + String.valueOf(e)));
                }
            }
            this._stop = true;
            this.interrupt();
        }
    }
}

