/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import de.renew.logging.gui.AppenderBuilder;
import de.renew.logging.gui.LoggingGuiPlugin;
import de.renew.plugin.PluginProperties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class AppenderFactory {
    private static final Logger LOGGER = Logger.getLogger(AppenderFactory.class);
    private static final String APPENDER_TYPE_PREFIX = "appender.type.";
    private static final String APPENDER_TYPE_CLASS = "class";
    private static final String APPENDER_TYPE_BUILDER = "builder";
    private static AppenderFactory _factory = null;
    private Map<String, AppenderBuilder> _builders = new Hashtable<String, AppenderBuilder>();

    private AppenderFactory() {
        PluginProperties props = LoggingGuiPlugin.getCurrent().getProperties();
        Enumeration<Object> enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            String className;
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(APPENDER_TYPE_PREFIX) || key.length() <= APPENDER_TYPE_PREFIX.length()) continue;
            String typeName = key.substring(APPENDER_TYPE_PREFIX.length());
            if (typeName.indexOf(".") >= 0) {
                typeName = typeName.substring(0, typeName.indexOf("."));
            }
            if (this._builders.containsKey(typeName)) continue;
            String builderName = props.getProperty(APPENDER_TYPE_PREFIX + typeName + ".builder");
            AppenderBuilder builder = null;
            if (builderName != null) {
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(builderName);
                    builder = (AppenderBuilder)clazz.newInstance();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Can't load instance of builder class for appender type " + typeName));
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (builder == null && (className = props.getProperty(APPENDER_TYPE_PREFIX + typeName + ".class")) != null) {
                try {
                    builder = new DefaultAppenderBuilder(className);
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (builder == null || this._builders.containsKey(typeName)) continue;
            this._builders.put(typeName, builder);
        }
    }

    public static AppenderFactory getInstance() {
        if (_factory == null) {
            _factory = new AppenderFactory();
        }
        return _factory;
    }

    public Appender createNewAppender(String appenderTypeName) throws InstantiationException {
        Appender appender = null;
        AppenderBuilder builder = this._builders.get(appenderTypeName);
        if (builder != null) {
            appender = builder.newInstance();
        }
        return appender;
    }

    public String[] getAllAppenderTypes() {
        return this._builders.keySet().toArray(new String[0]);
    }

    private class DefaultAppenderBuilder
    implements AppenderBuilder {
        private final Class<?> _class;

        protected DefaultAppenderBuilder(String appenderClassName) throws ClassNotFoundException {
            this.getClass();
            this._class = Class.forName(appenderClassName);
        }

        @Override
        public Appender newInstance() throws InstantiationException {
            try {
                return (Appender)this._class.newInstance();
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InstantiationException();
            }
        }
    }
}

