/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Calculator;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.Reference;
import de.renew.unify.Referer;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.util.Types;
import de.renew.util.Value;
import java.util.Set;
import org.apache.log4j.Logger;

public class TypeConstrainer
implements Referer {
    public static final Logger LOGGER = Logger.getLogger(TypeConstrainer.class);
    private final Class<?> _type;
    private final Reference _reference;

    private TypeConstrainer(Class<?> type, Object value, StateRecorder recorder) {
        this._type = type;
        this._reference = new Reference(value, this, recorder);
    }

    public static void constrain(Class<?> type, Object value, StateRecorder recorder) throws Impossible {
        if (type == Types.UNTYPED) {
            return;
        }
        if (Unify.isComplete(value)) {
            TypeConstrainer.check(type, value);
        } else {
            new TypeConstrainer(type, value, recorder);
        }
    }

    private static void check(Class<?> type, Object value) throws Impossible {
        if (value instanceof Calculator) {
            Calculator calculator = (Calculator)value;
            Class<?> valueType = calculator.getType();
            if (type != valueType && (type.isPrimitive() || !Types.allowsReferenceWidening(valueType, type))) {
                try {
                    String message = "Type mismatch: Primitive " + String.valueOf(type) + ", calculation result: " + String.valueOf(valueType);
                    LOGGER.debug((Object)message);
                    throw new Impossible(message);
                }
                catch (RuntimeException e) {
                    String message = "Type mismatch (diagnostics not available).";
                    LOGGER.debug((Object)message, (Throwable)e);
                    throw new Impossible(message, e);
                }
            }
        } else if (value instanceof Value) {
            if (!type.isPrimitive() || !Types.objectify(type).isInstance(((Value)value).value)) {
                try {
                    String message = "Type mismatch: Class " + String.valueOf(type) + ", primitive value: " + String.valueOf(value);
                    LOGGER.debug((Object)message);
                    throw new Impossible(message);
                }
                catch (RuntimeException e) {
                    String message = "Type mismatch (diagnostics not available).";
                    LOGGER.debug((Object)message, (Throwable)e);
                    throw new Impossible(message, e);
                }
            }
        } else if (value == null) {
            if (type.isPrimitive()) {
                try {
                    String message = "Type mismatch: Primitive " + String.valueOf(type) + ", null reference";
                    LOGGER.debug((Object)message);
                    throw new Impossible(message);
                }
                catch (RuntimeException e) {
                    String message = "Type mismatch (diagnostics not available).";
                    LOGGER.debug((Object)message, (Throwable)e);
                    throw new Impossible(message, e);
                }
            }
        } else if (!type.isInstance(value)) {
            try {
                String message = "Type mismatch: Class " + String.valueOf(type) + ", object: " + String.valueOf(value);
                LOGGER.debug((Object)message);
                throw new Impossible(message);
            }
            catch (RuntimeException e) {
                String message = "Type mismatch (diagnostics not available).";
                LOGGER.debug((Object)message, (Throwable)e);
                throw new Impossible(message, e);
            }
        }
    }

    @Override
    public void possiblyCompleted(Set<Notifiable> listeners, StateRecorder recorder) throws Impossible {
        TypeConstrainer.check(this._type, this._reference.getValue());
    }
}

