/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Aggregate;
import de.renew.unify.ComponentBranch;
import de.renew.unify.Tuple;
import de.renew.unify.TupleIndexVisitor;
import de.renew.util.HashedRelation;
import java.io.Serializable;

public class ArityBranch
implements Serializable {
    private final HashedRelation<Integer, Object> _hashCodeRelation = new HashedRelation();
    private ComponentBranch[] _branches = new ComponentBranch[0];

    public HashedRelation<Integer, Object> getHashCodeRelation() {
        return this._hashCodeRelation;
    }

    private void setCapacity(int cap) {
        ComponentBranch[] newBranches = new ComponentBranch[cap];
        System.arraycopy(this._branches, 0, newBranches, 0, Math.min(cap, this._branches.length));
        this._branches = newBranches;
    }

    private void ensureCapacity(int cap) {
        if (this._branches.length < cap) {
            this.setCapacity(cap);
        }
    }

    private void trim() {
        int cap;
        for (cap = this._branches.length; cap > 0 && this._branches[cap - 1] == null; --cap) {
        }
        if (cap < this._branches.length) {
            this.setCapacity(cap);
        }
    }

    void traverse(TupleIndexVisitor visitor, Object remainder) {
        if (visitor.visitIndex(this, remainder)) {
            int index;
            int arity;
            Aggregate aggregate;
            if (remainder instanceof Aggregate) {
                aggregate = (Aggregate)remainder;
                arity = aggregate.getReferences().length;
                if (arity == 0) {
                    return;
                }
                index = remainder instanceof Tuple ? arity : 0;
            } else {
                return;
            }
            this.ensureCapacity(index + 1);
            if (this._branches[index] == null) {
                this._branches[index] = new ComponentBranch(arity);
            }
            this._branches[index].traverse(visitor, aggregate);
            if (this._branches[index].size() == 0) {
                this._branches[index] = null;
                this.trim();
            }
        }
    }
}

