/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.net.Net;
import de.renew.net.NetNotFoundException;
import de.renew.net.loading.NetLoader;
import de.renew.shadow.ShadowCompiler;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetLoader;
import de.renew.shadow.ShadowPreprocessor;
import de.renew.shadow.SyntaxException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class ShadowNetSystem
implements Serializable {
    public static Logger logger = Logger.getLogger(ShadowNetSystem.class);
    static final long serialVersionUID = 4619730346099695519L;
    private Set<ShadowNet> nets = new HashSet<ShadowNet>();
    private ShadowCompilerFactory defaultCompilerFactory = null;
    private transient Set<ShadowNet> compiledNets = new HashSet<ShadowNet>();
    private transient Set<ShadowNet> uncompiledNets = new HashSet<ShadowNet>();
    private transient ShadowNetLoader netLoader = null;

    public ShadowNetSystem(ShadowCompilerFactory defaultCompilerFactory) {
        this.setDefaultCompilerFactory(defaultCompilerFactory);
    }

    public ShadowNetSystem(ShadowCompilerFactory defaultCompilerFactory, ShadowNetLoader netLoader) {
        this(defaultCompilerFactory);
        this.setNetLoader(netLoader);
    }

    public void setDefaultCompilerFactory(ShadowCompilerFactory defaultCompilerFactory) {
        this.defaultCompilerFactory = defaultCompilerFactory;
        this.uncompiledNets.addAll(this.compiledNets);
        this.compiledNets.clear();
    }

    public ShadowCompilerFactory getDefaultCompilerFactory() {
        return this.defaultCompilerFactory;
    }

    public void setNetLoader(ShadowNetLoader netLoader) {
        this.netLoader = netLoader;
    }

    public ShadowNetLoader getNetLoader() {
        return this.netLoader;
    }

    protected void add(ShadowNet net) {
        this.nets.add(net);
        if (!this.compiledNets.contains(net)) {
            this.uncompiledNets.add(net);
        }
    }

    protected void remove(ShadowNet net) {
        this.nets.remove(net);
        this.compiledNets.remove(net);
        this.uncompiledNets.remove(net);
    }

    public void markAsCompiled(ShadowNet net) {
        if (this.nets.contains(net)) {
            this.compiledNets.add(net);
            this.uncompiledNets.remove(net);
        }
    }

    public Set<ShadowNet> elements() {
        return Collections.unmodifiableSet(this.nets);
    }

    private Set<ShadowNet> uncompiledElements() {
        return new HashSet<ShadowNet>(this.uncompiledNets);
    }

    private boolean hasUncompiledElements() {
        return !this.uncompiledNets.isEmpty();
    }

    public synchronized ShadowLookup compile() throws SyntaxException {
        logger.debug((Object)(String.valueOf(this) + " is compiled with default compiler factory " + String.valueOf(this.defaultCompilerFactory)));
        ShadowLookup result = this.compile(new ShadowLookup(), true);
        return result;
    }

    public synchronized ShadowLookup compileMore() throws SyntaxException {
        ShadowLookup lookup = new ShadowLookup();
        Iterator<Net> known = Net.allKnownNets();
        while (known.hasNext()) {
            Net net = known.next();
            lookup.setNet(net.getName(), net);
        }
        return this.compile(lookup, false);
    }

    private ShadowLookup compile(ShadowLookup lookup, boolean mayRunPreprocessors) throws SyntaxException {
        this.createNets(lookup);
        this.preprocessNets(lookup, mayRunPreprocessors);
        boolean preprocessorsHaveRun = mayRunPreprocessors;
        while (this.hasUncompiledElements()) {
            for (ShadowNet shadowNet : this.uncompiledElements()) {
                ShadowCompiler compiler = shadowNet.createInititalizedShadowNetCompiler(lookup);
                ShadowPreprocessor[] preprocessors = compiler.getRequiredPreprocessors();
                if (preprocessors != null && preprocessors.length > 0 && !preprocessorsHaveRun) {
                    throw new SyntaxException("Net " + shadowNet.getName() + " was dynamically loaded and requires a preprocessing phase. that is not supported", new String[0]);
                }
                logger.debug((Object)("compiling " + shadowNet.getName() + " using " + String.valueOf(compiler)));
                compiler.compile(shadowNet);
                this.markAsCompiled(shadowNet);
            }
            preprocessorsHaveRun = false;
        }
        return lookup;
    }

    private void createNets(ShadowLookup lookup) throws SyntaxException {
        for (ShadowNet shadowNet : this.uncompiledElements()) {
            String netName = shadowNet.getName();
            if (Net.isKnownNet(netName) || lookup.getNet(netName) != null) {
                throw new SyntaxException("Detected two nets with the same name: " + shadowNet.getName() + ".");
            }
            Net net = shadowNet.createInititalizedShadowNetCompiler(lookup).createNet(shadowNet.getName());
            lookup.setNet(shadowNet.getName(), net);
        }
    }

    private void preprocessNets(ShadowLookup lookup, boolean mayRunPreprocessors) throws SyntaxException {
        HashSet<ShadowPreprocessor> preprocessors = new HashSet<ShadowPreprocessor>();
        HashSet<String> preprocessorNets = new HashSet<String>();
        for (ShadowNet shadowNet : this.uncompiledElements()) {
            ShadowCompiler compiler = shadowNet.createInititalizedShadowNetCompiler(lookup);
            ShadowPreprocessor[] prepArray = compiler.getRequiredPreprocessors();
            if (prepArray == null || prepArray.length <= 0) continue;
            preprocessors.addAll(Arrays.asList(prepArray));
            preprocessorNets.add(shadowNet.getName());
        }
        if (preprocessors.isEmpty()) {
            return;
        }
        if (!mayRunPreprocessors) {
            StringBuffer buf = new StringBuffer();
            if (preprocessorNets.size() == 1) {
                buf.append("The dynamically loaded net ");
                buf.append((String)preprocessorNets.iterator().next());
                buf.append(" requires");
            } else {
                buf.append("Some dynamically loaded nets (");
                Iterator i = preprocessorNets.iterator();
                while (i.hasNext()) {
                    buf.append((String)i.next());
                    if (!i.hasNext()) continue;
                    buf.append(", ");
                }
                buf.append(" require");
            }
            buf.append(" a preprocessing phase. This is not allowed.");
            throw new SyntaxException(buf.toString(), new String[0]);
        }
        for (ShadowPreprocessor preprocessor : preprocessors) {
            preprocessor.setShadowLookup(lookup);
            preprocessor.preprocess(this);
        }
    }

    private Net appendNet(ShadowLookup lookup, String name) throws NetNotFoundException {
        if (this.getNetLoader() != null) {
            Net net;
            ShadowNet shadowNet = this.getNetLoader().loadShadowNet(name, this);
            if (!shadowNet.getName().equals(name)) {
                throw new NetNotFoundException(name + " (ShadowNetLoader provided " + shadowNet.getName() + " instead)");
            }
            try {
                net = shadowNet.createInititalizedShadowNetCompiler(lookup).createNet(shadowNet.getName());
            }
            catch (SyntaxException e) {
                throw new NetNotFoundException(e);
            }
            lookup.setNet(shadowNet.getName(), net);
            return net;
        }
        throw new NetNotFoundException(name);
    }

    LoopbackNetLoader createNetLoader(ShadowLookup lookup) {
        return new LoopbackNetLoader(lookup);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.uncompiledNets = new HashSet<ShadowNet>(this.nets);
        this.compiledNets = new HashSet<ShadowNet>();
    }

    private class LoopbackNetLoader
    implements NetLoader {
        private ShadowLookup lookup;

        LoopbackNetLoader(ShadowLookup lookup) {
            this.lookup = lookup;
        }

        @Override
        public Net loadNet(String netName) throws NetNotFoundException {
            return ShadowNetSystem.this.appendNet(this.lookup, netName);
        }
    }
}

