/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.QuicklyTesting;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.events.Testing;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.unify.Impossible;

class TestArcExecutable
implements EarlyExecutable {
    SimulatablePlaceInstance pInstance;
    TransitionInstance tInstance;
    Object token;
    boolean trace;
    boolean releaseImmediately;

    TestArcExecutable(SimulatablePlaceInstance pInstance, TransitionInstance tInstance, Object token, boolean releaseImmediately, boolean trace) {
        this.pInstance = pInstance;
        this.tInstance = tInstance;
        this.token = token;
        this.trace = trace;
        this.releaseImmediately = releaseImmediately;
    }

    public long lockPriority() {
        return this.pInstance.lockOrder;
    }

    @Override
    public int phase() {
        return -2;
    }

    public void lock() {
        this.pInstance.lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        this.pInstance.testToken(this.token);
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        if (this.releaseImmediately) {
            if (this.trace) {
                SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new QuicklyTesting(this.token, this.pInstance), (PlaceInstance)this.pInstance);
            }
            this.pInstance.untestToken(this.token);
        } else if (this.trace) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Testing(this.token, this.pInstance), (PlaceInstance)this.pInstance);
        }
    }

    @Override
    public void rollback() {
        this.pInstance.untestToken(this.token);
    }

    public void unlock() {
        this.pInstance.lock.unlock();
    }
}

