/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.Checking;
import de.renew.engine.events.Removing;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.unify.Impossible;

class InputArcExecutable
implements EarlyExecutable {
    SimulatablePlaceInstance pInstance;
    TransitionInstance tInstance;
    Object token;
    double delay;
    boolean trace;
    boolean releaseImmediately;
    double removeTime;

    InputArcExecutable(SimulatablePlaceInstance pInstance, TransitionInstance tInstance, Object token, double delay, boolean releaseImmediately, boolean trace) {
        this.pInstance = pInstance;
        this.tInstance = tInstance;
        this.token = token;
        this.delay = delay;
        this.trace = trace;
        this.releaseImmediately = releaseImmediately;
    }

    public long lockPriority() {
        return this.pInstance.lockOrder;
    }

    @Override
    public int phase() {
        return -3;
    }

    public void lock() {
        this.pInstance.lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        this.removeTime = this.pInstance.removeToken(this.token, this.delay);
    }

    static void traceInArc(StepIdentifier stepIdentifier, boolean checking, Object token, SimulatablePlaceInstance pInstance, TransitionInstance tInstance) {
        if (checking) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Checking(token, pInstance), (PlaceInstance)pInstance);
        } else {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Removing(token, pInstance), (PlaceInstance)pInstance);
        }
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        if (this.releaseImmediately) {
            if (this.trace) {
                InputArcExecutable.traceInArc(stepIdentifier, true, this.token, this.pInstance, this.tInstance);
            }
            this.pInstance.insertToken(this.token, SearchQueue.getTime());
        } else if (this.trace) {
            InputArcExecutable.traceInArc(stepIdentifier, false, this.token, this.pInstance, this.tInstance);
        }
    }

    @Override
    public void rollback() {
        this.pInstance.internallyInsertToken(this.token, this.removeTime, false);
    }

    public void unlock() {
        this.pInstance.lock.unlock();
    }
}

