/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.TypeConstrainer;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class TypeCheckingExpression
extends ExpressionWithTypeField {
    Expression argument;

    public TypeCheckingExpression(Class<?> type, Expression argument) {
        super(type);
        this.argument = argument;
    }

    public Expression getArgument() {
        return this.argument;
    }

    @Override
    public boolean isInvertible() {
        return this.argument.isInvertible();
    }

    @Override
    public Object startEvaluation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        Object result = this.argument.startEvaluation(mapper, recorder, checker);
        TypeConstrainer.constrain(this.getType(), result, recorder);
        return result;
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        Variable target = new Variable();
        checker.addCalculated(this.getType(), target, this.argument.registerCalculation(mapper, recorder, checker), recorder);
        return target.getValue();
    }

    public String toString() {
        return "TypeCheckingExpr(" + Types.typeToString((Class)this.getType()) + ": " + String.valueOf(this.argument) + ")";
    }
}

