/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database.entitylayer;

import de.renew.database.entitylayer.Attribute;
import de.renew.database.entitylayer.NoSuchEntityException;
import de.renew.database.entitylayer.PrimaryKeyNotUniqueException;
import de.renew.database.entitylayer.SQLDialect;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class Entity
implements Cloneable {
    public static final byte NOT_MODIFIED = 0;
    public static final byte MODIFIED = 1;
    public static final byte NEW = 2;
    private static PrintStream messageStream = null;
    private Connection connection;
    private SQLDialect dialect;
    private byte state;
    private Hashtable<String, Object> values;
    private static Logger logger = Logger.getLogger(Entity.class);

    public Entity(Connection connection, SQLDialect dialect) {
        this.connection = connection;
        this.dialect = dialect;
        this.clear();
    }

    public void clear() {
        this.values = new Hashtable();
        this.state = (byte)2;
    }

    public Object clone() throws CloneNotSupportedException {
        Entity newEntity = (Entity)super.clone();
        newEntity.values = new Hashtable();
        Attribute[] attributes = this.getAttributes();
        for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
            Object oldValue = this.getValue(attributes[attributeNumber].getName());
            if (oldValue == null) continue;
            newEntity.values.put(attributes[attributeNumber].getName(), oldValue);
        }
        Attribute[] primaryKey = this.getPrimaryKey();
        for (int attributeNumber = 0; attributeNumber < primaryKey.length; ++attributeNumber) {
            newEntity.values.remove(attributes[attributeNumber].getName());
        }
        newEntity.state = (byte)2;
        return newEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Statement statement = null;
            try {
                if (this.state != 2) {
                    String update = this.dialect.getDeleteString(this.getTableName(), this.getPrimaryKey(), this.getPrimaryKeyValue());
                    if (messageStream != null) {
                        messageStream.println("Entity: Executing " + update);
                    }
                    statement = this.connection.createStatement();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (delete): " + update));
                    }
                    statement.executeUpdate(update);
                    if (messageStream != null) {
                        messageStream.println("Entity: Done.");
                    }
                }
                this.clear();
            }
            finally {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
        }
    }

    public static void deleteEntities(Entity entityTemplate) throws SQLException {
        Entity.deleteEntities(entityTemplate, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntities(Entity entityTemplate, String condition) throws SQLException {
        Class<?> clazz = entityTemplate.getClass();
        synchronized (clazz) {
            Statement statement = null;
            try {
                String update = entityTemplate.getDialect().getDeleteString(entityTemplate.getTableName(), condition);
                if (messageStream != null) {
                    messageStream.println("Entity: Executing " + update);
                }
                statement = entityTemplate.getConnection().createStatement();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (deleteEntities): " + update));
                }
                statement.executeUpdate(update);
                if (messageStream != null) {
                    messageStream.println("Entity: Done.");
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
        }
    }

    public abstract Attribute[] getAttributes();

    public Connection getConnection() {
        return this.connection;
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public static Vector<Entity> getEntities(Entity entityTemplate) throws SQLException {
        return Entity.getEntitiesBySelectString(entityTemplate, entityTemplate.getDialect().getSelectString(entityTemplate.getTableName(), entityTemplate.getAttributes()));
    }

    public static Vector<Entity> getEntities(Entity entityTemplate, String condition) throws SQLException {
        return Entity.getEntitiesBySelectString(entityTemplate, entityTemplate.getDialect().getSelectString(entityTemplate.getTableName(), entityTemplate.getAttributes(), condition));
    }

    public static Vector<Entity> getEntities(Entity entityTemplate, String condition, String order) throws SQLException {
        return Entity.getEntitiesBySelectString(entityTemplate, entityTemplate.getDialect().getSelectString(entityTemplate.getTableName(), entityTemplate.getAttributes(), condition, order));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<Entity> getEntitiesBySelectString(Entity entityTemplate, String query) throws SQLException {
        Class<?> clazz = entityTemplate.getClass();
        synchronized (clazz) {
            Attribute[] attributes = entityTemplate.getAttributes();
            Vector<Entity> entities = new Vector<Entity>();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                if (messageStream != null) {
                    messageStream.println("Entity: Executing " + query);
                }
                statement = entityTemplate.getConnection().createStatement();
                resultSet = statement.executeQuery(query);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (getEntitiesBySelectString): " + query));
                }
                if (messageStream != null) {
                    messageStream.println("Entity: Done.");
                }
                while (resultSet.next()) {
                    Entity entity;
                    try {
                        entity = (Entity)entityTemplate.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new IllegalArgumentException("Clone of object template not possible.\nPossibly illegal attribute values?");
                    }
                    entity.clear();
                    for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
                        Object value = resultSet.getObject(attributeNumber + 1);
                        if (value == null) continue;
                        if (value instanceof BigDecimal) {
                            entity.setValue(attributes[attributeNumber].getName(), ((Number)value).intValue());
                            continue;
                        }
                        entity.setValue(attributes[attributeNumber].getName(), value);
                    }
                    entity.state = 0;
                    entities.addElement(entity);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            return entities;
        }
    }

    public abstract Attribute[] getPrimaryKey();

    public Object[] getPrimaryKeyValue() {
        Attribute[] primaryKey = this.getPrimaryKey();
        Object[] primaryKeyValue = new Object[primaryKey.length];
        for (int attributeNumber = 0; attributeNumber < primaryKey.length; ++attributeNumber) {
            primaryKeyValue[attributeNumber] = this.values.get(primaryKey[attributeNumber].getName());
        }
        return primaryKeyValue;
    }

    public byte getState() {
        return this.state;
    }

    public abstract String getTableName();

    public Object getValue(String name) {
        Object value = this.values.get(name);
        if (value != null && value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value;
    }

    public void load(Object primaryKeyValue) throws SQLException {
        this.load(new Object[]{primaryKeyValue});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Object[] primaryKeyValue) throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Attribute[] attributes = this.getAttributes();
            Attribute[] primaryKey = this.getPrimaryKey();
            if (primaryKeyValue.length != primaryKey.length) {
                throw new IllegalArgumentException("Wrong number of primary key values supplied.");
            }
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String query = this.dialect.getSelectStringWithPrimaryKey(this.getTableName(), attributes, primaryKey, primaryKeyValue);
                if (messageStream != null) {
                    messageStream.println("Entity: Executing " + query);
                }
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery(query);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (load): " + query));
                }
                if (messageStream != null) {
                    messageStream.println("Entity: Done.");
                }
                if (!resultSet.next()) {
                    throw new NoSuchEntityException("No entity with primary key " + this.dialect.getStringOfAttributesAndValues(primaryKey, primaryKeyValue) + " in table " + this.getTableName() + ".");
                }
                this.clear();
                int columnCount = resultSet.getMetaData().getColumnCount();
                for (int attributeNumber = 0; attributeNumber < columnCount; ++attributeNumber) {
                    Object value = resultSet.getObject(attributeNumber + 1);
                    if (value == null) continue;
                    if (value instanceof BigDecimal) {
                        this.values.put(attributes[attributeNumber].getName(), ((Number)value).intValue());
                        continue;
                    }
                    this.values.put(attributes[attributeNumber].getName(), value);
                }
                if (resultSet.next()) {
                    throw new PrimaryKeyNotUniqueException("Duplicate entity with primary key " + this.dialect.getStringOfAttributesAndValues(primaryKey, primaryKeyValue) + " in table " + this.getTableName() + ".");
                }
                this.state = 0;
            }
            catch (SQLException e) {
                this.clear();
                throw e;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Statement statement = null;
            Attribute[] attributes = this.getAttributes();
            Attribute[] primaryKey = this.getPrimaryKey();
            try {
                switch (this.state) {
                    case 2: {
                        int setPrimaryKeyValueCount = 0;
                        for (int attributeNumber = 0; attributeNumber < primaryKey.length; ++attributeNumber) {
                            if (this.values.get(primaryKey[attributeNumber].getName()) == null) continue;
                            ++setPrimaryKeyValueCount;
                        }
                        if (setPrimaryKeyValueCount > 0 && setPrimaryKeyValueCount < primaryKey.length) {
                            throw new IllegalStateException("The primary key value is only partially set.\nSet it completely to define its value or set it not at all to let the save method auto-set it.");
                        }
                        if (setPrimaryKeyValueCount < primaryKey.length) {
                            this.dialect.setUniquePrimaryKeyValueBeforeInsert(this.connection, this, this.values);
                        }
                        String update = this.dialect.getInsertString(this.getTableName(), attributes, this.values, primaryKey);
                        if (setPrimaryKeyValueCount < primaryKey.length) {
                            this.dialect.setUniquePrimaryKeyValueAfterInsert(this.connection, this, this.values);
                        }
                        if (messageStream != null) {
                            messageStream.println("Entity: Executing " + update);
                        }
                        statement = this.connection.createStatement();
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (save): " + update));
                        }
                        statement.executeUpdate(update);
                        if (messageStream == null) break;
                        messageStream.println("Entity: Done.");
                        break;
                    }
                    case 1: {
                        String update = this.dialect.getUpdateString(this.getTableName(), attributes, this.values, primaryKey);
                        if (messageStream != null) {
                            messageStream.println("Entity: Executing " + update);
                        }
                        statement = this.connection.createStatement();
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (save): " + update));
                        }
                        statement.executeUpdate(update);
                        if (messageStream == null) break;
                        messageStream.println("Entity: Done.");
                    }
                }
                this.state = 0;
            }
            finally {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
        }
    }

    public static void setMessageStream(PrintStream messageStream) {
        Entity.messageStream = messageStream;
    }

    public void setValue(String name, Object value) {
        if (this.state != 2) {
            Attribute[] primaryKey = this.getPrimaryKey();
            for (int attributeNumber = 0; attributeNumber < primaryKey.length; ++attributeNumber) {
                if (!name.equals(primaryKey[attributeNumber].getName())) continue;
                throw new IllegalArgumentException("It is illegal to change the primary key value of an existing entity.");
            }
        }
        if (value == null) {
            this.values.remove(name);
        } else {
            this.values.put(name, value);
        }
        if (this.state == 0) {
            this.state = 1;
        }
    }

    public String toString() {
        return this.getClass().getName() + "{" + this.dialect.getStringOfAttributesAndValues(this.getAttributes(), this.values) + "}";
    }

    public void touch() {
        if (this.state == 0) {
            this.state = 1;
        }
    }
}

