/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.NetAction;
import de.renew.database.TokenAction;
import de.renew.database.TransactionSource;
import de.renew.net.NetInstance;
import de.renew.net.SimulatablePlaceInstance;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Transaction {
    private boolean autoCommit;
    private Vector<NetAction> createActions;
    private Vector<NetAction> deleteActions;
    private static Logger logger = Logger.getLogger(Transaction.class);
    private Vector<TokenAction> delayedAddActions;
    private Vector<TokenAction> addActions;
    private Vector<TokenAction> removeActions;

    public Transaction(boolean autoCommit) {
        this.autoCommit = autoCommit;
        this.createActions = new Vector();
        this.deleteActions = new Vector();
        this.delayedAddActions = new Vector();
        this.addActions = new Vector();
        this.removeActions = new Vector();
    }

    public synchronized void createNet(NetInstance instance) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(Transaction.class.getSimpleName() + ": creating net action."));
        }
        this.createActions.addElement(new NetAction(instance));
        if (this.autoCommit) {
            this.commit();
        }
    }

    public synchronized void deleteNet(NetInstance instance) throws Exception {
        this.deleteActions.addElement(new NetAction(instance));
        if (this.autoCommit) {
            this.commit();
        }
    }

    public synchronized void addToken(SimulatablePlaceInstance placeInstance, Object token, double time, boolean automaticInsertion) throws Exception {
        placeInstance.reserve(token);
        TokenAction action = new TokenAction(placeInstance, token, time);
        if (automaticInsertion) {
            this.delayedAddActions.addElement(action);
        }
        this.addActions.addElement(action);
        if (this.autoCommit) {
            this.commit();
        }
    }

    public synchronized void removeToken(SimulatablePlaceInstance placeInstance, Object token, double time) throws Exception {
        placeInstance.reserve(token);
        this.removeActions.addElement(new TokenAction(placeInstance, token, time));
        if (this.autoCommit) {
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputTokens() {
        int n = this.delayedAddActions.size();
        for (int i = 0; i < n; ++i) {
            TokenAction tokenAction = this.delayedAddActions.elementAt(i);
            SimulatablePlaceInstance pi = tokenAction.getPlaceInstance();
            Object token = tokenAction.getToken();
            double time = tokenAction.getTime();
            pi.lock.lock();
            try {
                pi.internallyInsertToken(token, time, false);
                continue;
            }
            finally {
                pi.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreserveTokens(Vector<TokenAction> tokenActions) {
        int n = tokenActions.size();
        for (int i = 0; i < n; ++i) {
            TokenAction tokenAction = tokenActions.elementAt(i);
            SimulatablePlaceInstance pi = tokenAction.getPlaceInstance();
            Object token = tokenAction.getToken();
            pi.lock.lock();
            try {
                pi.unreserve(token);
                continue;
            }
            finally {
                pi.lock.unlock();
            }
        }
    }

    private void unreserveOutputTokens() {
        this.unreserveTokens(this.addActions);
    }

    private void unreserveInputTokens() {
        this.unreserveTokens(this.removeActions);
    }

    private void clear() {
        this.createActions.removeAllElements();
        this.delayedAddActions.removeAllElements();
        this.addActions.removeAllElements();
        this.removeActions.removeAllElements();
        this.deleteActions.removeAllElements();
    }

    public synchronized void commit() throws Exception {
        Object[] ca = new NetAction[this.createActions.size()];
        this.createActions.copyInto(ca);
        Object[] aa = new TokenAction[this.addActions.size()];
        this.addActions.copyInto(aa);
        Object[] ra = new TokenAction[this.removeActions.size()];
        this.removeActions.copyInto(ra);
        Object[] da = new NetAction[this.deleteActions.size()];
        this.deleteActions.copyInto(da);
        TransactionSource.perform((NetAction[])ca, (TokenAction[])aa, (TokenAction[])ra, (NetAction[])da);
        this.outputTokens();
        this.unreserveOutputTokens();
        this.unreserveInputTokens();
        this.clear();
    }

    public synchronized void rollback() {
        this.unreserveOutputTokens();
        this.unreserveInputTokens();
        this.clear();
    }
}

