/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulationRunningException;
import de.renew.application.SimulatorPlugin;
import de.renew.database.SetupHelper;
import de.renew.database.TransactionSource;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.plugin.command.CLCommand;
import de.renew.shadow.ShadowNetSystem;
import de.renew.util.ObjectInputStreamUsingBottomLoader;
import de.renew.util.ParameteredCommandLine;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class StartSimulationCommand
implements CLCommand {
    private static final Logger LOGGER = Logger.getLogger(StartSimulationCommand.class);
    private final SimulatorPlugin _plugin;
    private static final String HELP_PARAM = "-h";
    private static final String ONLY_INIT_PARAM = "-i";

    public StartSimulationCommand(SimulatorPlugin plugin) {
        this._plugin = Objects.requireNonNull(plugin, "Need SimulatorPlugin reference");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] args, PrintStream response) {
        ParameteredCommandLine line = new ParameteredCommandLine(args, new String[]{HELP_PARAM, ONLY_INIT_PARAM}, new int[]{0, 0});
        String[] basicArgs = line.getRemainingArgs();
        if (basicArgs.length != 2 || line.hasParameter(HELP_PARAM)) {
            this.showSyntax(response);
            return;
        }
        SimulatorPlugin.getLock().lock();
        try {
            Future<Object> object = SimulationThreadPool.getNew().submitAndWait(() -> {
                String netSystemFileName = basicArgs[0];
                String primaryNetName = basicArgs[1];
                ShadowNetSystem netSystem = this.getShadowNetSystem(netSystemFileName);
                this._plugin.setupSimulation(null);
                this._plugin.insertNets(netSystem);
                SetupHelper.SimulationState state = this._plugin.restoreStateFromDatabase();
                if (!state.wasSimulationInited()) {
                    NetInstance primaryInstance = this._plugin.createNetInstance(primaryNetName);
                    response.println("Simulation set up, created net instance " + String.valueOf(primaryInstance) + ".");
                } else {
                    response.println("Simulation set up, restored state from database.");
                }
                if (!line.hasParameter(ONLY_INIT_PARAM)) {
                    SimulationEnvironment env = this._plugin.getCurrentEnvironment();
                    env.getSimulator().startRun();
                    response.println("Simulation running.");
                } else {
                    try {
                        TransactionSource.simulationStateChanged(true, false);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                return null;
            });
            object.get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof SimulationRunningException) {
                response.println("Simulation already running");
            } else {
                LOGGER.debug((Object)t.toString(), (Throwable)e);
                response.println(t);
                response.println("Cleaning up.");
                this._plugin.terminateSimulation();
            }
        }
        catch (SimulationRunningException e) {
            response.println("Simulation already running");
        }
        catch (Exception e) {
            LOGGER.debug((Object)e.toString(), (Throwable)e);
            response.println(e);
            response.println("Cleaning up.");
            this._plugin.terminateSimulation();
        }
        finally {
            SimulatorPlugin.getLock().unlock();
        }
    }

    private ShadowNetSystem getShadowNetSystem(String netSystemFileName) throws IOException {
        ShadowNetSystem netSystem;
        try (FileInputStream stream = new FileInputStream(netSystemFileName);
             ObjectInputStreamUsingBottomLoader input = new ObjectInputStreamUsingBottomLoader((InputStream)stream);){
            netSystem = (ShadowNetSystem)input.readObject();
        }
        catch (StreamCorruptedException | ClassCastException | ClassNotFoundException e) {
            throw new IllegalArgumentException("Invalid shadow net system (in file " + netSystemFileName + "): " + String.valueOf(e));
        }
        return netSystem;
    }

    public String getDescription() {
        return "set up a simulation with given nets (-h for help).";
    }

    public String getArguments() {
        return "fileNames";
    }

    public void showSyntax(PrintStream response) {
        response.println("Parameters: <net system> <primary net> [-i]");
        response.println("  <net system>  : The file name of the exported shadow net system to load.");
        response.println("  <primary net> : The name of the primary net to create an instance of.");
        response.println("  -i            : Initialize the simulation only, don't run it.");
        response.println("To configure the simulation engine and installed extensions, use the");
        response.println("available plugin properties before starting the simulation (e.g. ");
        response.println("de.renew.simulatorMode or de.renew.eagerSimulation).");
    }
}

