/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import de.renew.plugin.PluginManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Iconkit {
    public static Logger logger = Logger.getLogger(Iconkit.class);
    private static final int ID = 123;
    private static Iconkit instance = null;
    private final Hashtable<String, Image> images = new Hashtable(53);
    private Vector<String> fRegisteredImages = new Vector(10);
    private final MediaTracker tracker;

    public Iconkit(Component component) {
        this.tracker = new MediaTracker(component);
        instance = this;
    }

    public static synchronized Iconkit instance() {
        if (instance == null) {
            return new Iconkit(new Frame());
        }
        return instance;
    }

    public void registerImage(String fileName) {
        this.fRegisteredImages.addElement(fileName);
    }

    public Image registerAndLoadImage(Component component, String fileName) {
        this.registerImage(fileName);
        this.loadRegisteredImages();
        return this.getImage(fileName);
    }

    public Image loadImage(String filename) {
        if (this.images.containsKey(filename)) {
            return this.images.get(filename);
        }
        Image image = this.loadImageResource(filename);
        if (image != null) {
            this.images.put(filename, image);
        }
        return image;
    }

    public Image getImage(String filename) {
        if (this.images.containsKey(filename)) {
            return this.images.get(filename);
        }
        this.loadRegisteredImages();
        return this.images.get(filename);
    }

    private Image loadImageResource(String resourceName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL url = PluginManager.getInstance().getBottomClassLoader().getResource(resourceName);
            logger.debug((Object)(resourceName + "(" + String.valueOf(url) + ")"));
            if (url == null) {
                return toolkit.getImage(resourceName);
            }
            Object content = url.getContent();
            if (content instanceof ImageProducer) {
                return toolkit.createImage((ImageProducer)content);
            }
            if (content instanceof InputStream) {
                InputStream stream = (InputStream)content;
                return this.loadImageInputStream(toolkit, stream);
            }
            return toolkit.getImage(url);
        }
        catch (Exception ex) {
            logger.error((Object)("While loading " + resourceName + ":"));
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private Image loadImageInputStream(Toolkit toolkit, InputStream stream) throws IOException {
        boolean canReadMore;
        int max = 1024;
        if (stream.available() > max) {
            max = stream.available();
        }
        byte[] data = new byte[max];
        int pos = 0;
        do {
            int num;
            if (pos > max / 2) {
                byte[] newData = new byte[max *= 2];
                System.arraycopy(data, 0, newData, 0, pos);
                data = newData;
            }
            boolean bl = canReadMore = (num = stream.read(data, pos, max - pos)) > 0;
            if (!canReadMore) continue;
            pos += num;
        } while (canReadMore);
        stream.close();
        return toolkit.createImage(data, 0, pos);
    }

    private void loadRegisteredImages() {
        if (this.fRegisteredImages.size() == 0) {
            return;
        }
        Enumeration<String> k = this.fRegisteredImages.elements();
        while (k.hasMoreElements()) {
            String fileName = k.nextElement();
            if (this.images.get(fileName) != null) continue;
            this.tracker.addImage(this.loadImage(fileName), 123);
        }
        this.fRegisteredImages.removeAllElements();
        try {
            this.tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

