/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GUIProperties {
    public static Logger logger = Logger.getLogger(GUIProperties.class);
    private static Properties _properties = new Properties();
    private static Map<String, Boolean> lastBoolResults = new HashMap<String, Boolean>();

    private GUIProperties() {
    }

    public static void setProperties(Properties props) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setting GUI properties:" + String.valueOf(props)), new Throwable("StackTrace"));
        }
        _properties = props;
    }

    public static Properties getProperties() {
        return _properties;
    }

    protected static boolean returnBool(String property, String setMessage) {
        String propName = "de.renew." + property;
        String result = _properties.getProperty(propName);
        if (result == null && (result = System.getProperty(propName)) != null) {
            _properties.setProperty(property, result);
        }
        if (result == null) {
            result = "false";
            _properties.setProperty(property, result);
        } else if ("".equals(result)) {
            result = "true";
            _properties.setProperty(property, result);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: " + propName + "=" + result));
        }
        Boolean value = Boolean.valueOf(result);
        GUIProperties.printOptionalSetMessage(propName, value, setMessage);
        return value;
    }

    protected static void printOptionalSetMessage(String propName, Boolean newValue, String setMessage) {
        Boolean prevValue = lastBoolResults.get(propName);
        if (prevValue == null) {
            prevValue = Boolean.FALSE;
        }
        lastBoolResults.put(propName, newValue);
        if (!prevValue.booleanValue() && newValue.booleanValue() && setMessage != null) {
            logger.debug((Object)(setMessage + " activated."));
        } else if (prevValue.booleanValue() && !newValue.booleanValue() && setMessage != null) {
            logger.debug((Object)(setMessage + " deactivated."));
        }
    }

    protected static int returnInt(String property) {
        return GUIProperties.returnInt(property, -1);
    }

    protected static int returnInt(String property, int default_) {
        String value = GUIProperties.returnString(property);
        int result = default_;
        if (value != "none") {
            result = Integer.parseInt(value);
        }
        return result;
    }

    protected static String returnString(String property) {
        String propName = "de.renew." + property;
        String result = _properties.getProperty(propName);
        if (result == null && (result = System.getProperty(propName)) != null) {
            _properties.setProperty(property, result);
        }
        if (result == null) {
            result = "none";
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: " + propName + "=" + result));
        }
        return result;
    }

    public static boolean avoidFrameReshape() {
        return GUIProperties.returnBool("avoidFrameReshape", "Frame reshaping");
    }

    public static int loadServerPort() {
        return GUIProperties.returnInt("loadServerPort", 65111);
    }

    public static int menuFontSize() {
        return GUIProperties.returnInt("menuFontSize");
    }

    public static boolean windowResizable() {
        String result = _properties.getProperty("de.renew.windowResizable");
        if (result == null && (result = System.getProperty("de.renew.windowResizable")) != null) {
            _properties.setProperty("de.renew.windowResizable", result);
        }
        if (result == null) {
            if (System.getProperty("os.name").indexOf("Win") >= 0) {
                result = "true";
                _properties.setProperty("de.renew.windowResizable", result);
            }
        } else if ("".equals(result)) {
            result = "true";
            _properties.setProperty("de.renew.windowResizable", result);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: de.renew.windowResizable=" + result));
        }
        Boolean value = Boolean.valueOf(result);
        GUIProperties.printOptionalSetMessage("de.renew.windowResizable", value, "Menu frame resizability");
        return value;
    }

    public static int defaultFontSize() {
        return GUIProperties.returnInt("defaultFontSize");
    }

    public static boolean customToolBorders() {
        return GUIProperties.returnBool("customToolBorders", "Drawing old-style Renew tool buttons.");
    }

    public static boolean noGraphics() {
        return GUIProperties.returnBool("noGraphics", null);
    }

    public static String defaultFontName() {
        String result = GUIProperties.returnString("defaultFontName");
        if (result == "none") {
            result = "SansSerif";
        }
        return result;
    }
}

