/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.application.NewDrawingDialog;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingTypeManager;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.standard.StandardDrawingEditor;
import CH.ifa.draw.standard.StandardDrawingLookup;
import CH.ifa.draw.standard.StandardDrawingViewContainer;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.intern.CDockable;
import de.renew.util.StringUtil;
import de.renew.windowmanagement.Workbench;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class DrawingIOManager
implements CVetoClosingListener {
    public static Logger logger = Logger.getLogger(DrawingIOManager.class);
    private final StandardDrawingEditor fEditor;
    private final Workbench fWorkbench;
    private boolean _isClosingOfDrawingSuccessful;

    public DrawingIOManager(StandardDrawingEditor editor, Workbench workbench) {
        this.fEditor = editor;
        this.fWorkbench = workbench;
        this._isClosingOfDrawingSuccessful = true;
        this.fWorkbench.registerVetoClosingListener((CVetoClosingListener)this);
    }

    public Drawing promptChooseNew() {
        DrawingTypeManager dtm = DrawingTypeManager.getInstance();
        Hashtable<String, SimpleFileFilter> drawingTypes = dtm.getDrawingTypes();
        Set typeNames = drawingTypes.keySet();
        String[] types = typeNames.toArray(new String[typeNames.size()]);
        String[] descriptions = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            descriptions[i] = ((SimpleFileFilter)drawingTypes.get(types[i])).getDescription();
        }
        NewDrawingDialog dialog = new NewDrawingDialog(this.fWorkbench.getMainFrame(), descriptions, 0);
        int result = dialog.showDialog();
        if (result >= 0 && result < types.length) {
            Drawing drawing = DrawingTypeManager.getDrawingFromName(types[result]);
            this.fEditor.openDrawing(drawing);
            return drawing;
        }
        return null;
    }

    public void updateName(Drawing drawing, File filename) {
        StandardDrawingViewContainer container = this.fEditor.getDrawingLookup().getViewContainerForDrawing(drawing);
        try {
            filename = filename.getCanonicalFile();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        String nameOnly = StringUtil.getFilename((String)filename.getName());
        container.setTitleText(nameOnly);
        drawing.setName(nameOnly);
        drawing.setFilename(filename);
    }

    public boolean saveDrawing(Drawing drawing) {
        File filename = drawing.getFilename();
        if (filename == null || !drawing.getDefaultFileFilter().accept(filename)) {
            if (!this.promptSaveAs(drawing)) {
                return false;
            }
            filename = drawing.getFilename();
        }
        this.saveDrawing(drawing, filename);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(StandardDrawingLookup.class.getName() + ": saved drawing: " + String.valueOf(filename)));
        }
        DrawPlugin.getCurrent().updateRecentlySavedList(filename.getAbsolutePath());
        return true;
    }

    public void closing(CVetoClosingEvent cVetoClosingEvent) {
        Iterator it = cVetoClosingEvent.iterator();
        while (it.hasNext() && !cVetoClosingEvent.isCanceled()) {
            StandardDrawingViewContainer container;
            Drawing drawing;
            CDockable dockable = (CDockable)it.next();
            if (!(dockable instanceof StandardDrawingViewContainer) || !(drawing = (container = (StandardDrawingViewContainer)dockable).getView().drawing()).isModified()) continue;
            container.toFront();
            if (!this.handleModifiedDrawing(drawing)) {
                cVetoClosingEvent.cancel();
                this._isClosingOfDrawingSuccessful = !cVetoClosingEvent.isCanceled();
                continue;
            }
            this._isClosingOfDrawingSuccessful = true;
        }
    }

    public boolean getClosingResult() {
        return this._isClosingOfDrawingSuccessful;
    }

    public boolean handleModifiedDrawing(Drawing drawing) {
        Object[] options = new Object[]{"Save now", "Close / Do not save", "Cancel"};
        Icon icon = null;
        int answer = JOptionPane.showOptionDialog(this.fWorkbench.getMainFrame(), "Renew: The drawing \"" + drawing.getName() + "\" you are about to close has been modified.\n What do you want to do?", "Save drawing?", 0, 3, icon, options, options[0]);
        switch (answer) {
            case 0: {
                this.saveDrawing(drawing);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                return false;
            }
            case -1: {
                return false;
            }
            default: {
                assert (false) : "JOptionPane returned unexpected result: " + answer;
                break;
            }
        }
        return true;
    }

    public void closed(CVetoClosingEvent cVetoClosingEvent) {
    }

    public void promptOpen(FileFilter ff) {
        File[] files = this.getIOHelper().getLoadPath(null, ff, true);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (ff instanceof SimpleFileFilter) {
                    files[i] = DrawingFileHelper.checkAndAddExtension(files[i], (SimpleFileFilter)ff);
                }
                this.fEditor.openOrLoadDrawing(files[i]);
            }
        }
    }

    public void promptOpenURL() {
        String header = "Type in URL:\n Accepted protocols are: http, file, jar.\nIf not specified I will try to use http.\nExamples:\nhttp://my.server.tld/referencenet.rnw.\n file:///my/path/to/nets/net.rnw.\njar:file:///my/path/to/jar/the.jar!/path/to/file/net.rnw";
        Object in = JOptionPane.showInputDialog(DrawPlugin.getGui().getFrame(), (Object)header);
        if (in != null) {
            if (!(((String)in).startsWith("jar:") || ((String)in).startsWith("file://") || ((String)in).startsWith("http://"))) {
                in = "http://" + (String)in;
            }
            try {
                URL url = new URL((String)in);
                logger.debug((Object)url);
                this.getIOHelper().loadAndOpenDrawings(url);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private IOHelper getIOHelper() {
        return DrawPlugin.getCurrent().getIOHelper();
    }

    public void promptInsert() {
        SimpleFileFilter ff = this.fEditor.drawing().getDefaultFileFilter();
        File file = this.getIOHelper().getLoadPath(null, ff);
        if ((file = DrawingFileHelper.checkAndAddExtension(file, ff)) != null) {
            this.fEditor.loadAndInsertDrawing(file);
        }
    }

    public void saveDrawingAs(Drawing drawing) {
        File filename = drawing.getFilename();
        if (!this.promptSaveAs(drawing)) {
            this.fEditor.showStatus("Could not save File: " + String.valueOf(filename));
        } else {
            filename = drawing.getFilename();
            this.saveDrawing(drawing, filename);
        }
    }

    public void saveDrawing(Drawing drawing, File filename) {
        String text = " drawing " + drawing.getName() + " as " + String.valueOf(filename);
        this.fEditor.showStatus("Saving" + text + "...");
        DrawingFileHelper.saveDrawing(drawing, filename, this.fEditor);
        this.fEditor.showStatus("Saved" + text + ".");
        this.fEditor.autosaveManager.renameDrawing(drawing);
    }

    public boolean promptSaveAs(Drawing drawing) {
        int answer;
        SimpleFileFilter ff = drawing.getDefaultFileFilter();
        File file = drawing.getFilename();
        if (file == null) {
            file = new File(this.getIOHelper().getLastPath(), drawing.getName());
            file = DrawingFileHelper.checkAndAddExtension(file, ff);
        }
        this.fEditor.toolDone();
        file = this.getIOHelper().getSavePath(file, ff);
        if (file == null) {
            return false;
        }
        if ((file = DrawingFileHelper.checkAndAddExtension(file, ff)).exists() && (answer = JOptionPane.showConfirmDialog(DrawPlugin.getGui().getFrame(), "The file \"" + String.valueOf(file) + "\" does already exist.\nDo you want do proceed?", "Renew: Confirm overwrite.", 0)) >= 1) {
            return false;
        }
        this.updateName(drawing, file);
        drawing.setBackupStatus(false);
        return true;
    }
}

