/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.util.AutosaveSaver;
import de.renew.util.Scheduler;
import de.renew.util.StringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AutosaveTask
implements Runnable {
    public static Logger logger = Logger.getLogger(AutosaveTask.class);
    private Drawing drawing;
    private long lastSaved;
    private long interval;
    private File autosaveFilename = null;
    private AutosaveSaver saver;

    public AutosaveTask(AutosaveSaver saver, Drawing drawing, long interval) {
        this.saver = saver;
        this.drawing = drawing;
        this.interval = interval;
        this.reset();
        Scheduler.instance().executeIn((Runnable)this, interval);
    }

    private void touch(File filename) {
        try {
            FileOutputStream stream = new FileOutputStream(filename);
            stream.close();
        }
        catch (IOException e) {
            this.interval = 0L;
            logger.debug((Object)("Autosave of drawing " + this.drawing.getName() + " cancelled: " + String.valueOf(e)));
        }
    }

    public synchronized void reset() {
        this.lastSaved = System.currentTimeMillis();
    }

    public synchronized void terminate() {
        this.interval = 0L;
        Scheduler.instance().cancel((Runnable)this);
        if (this.autosaveFilename != null && this.autosaveFilename.exists()) {
            logger.debug((Object)("Deleting autosave copy " + String.valueOf(this.autosaveFilename) + "..."));
            this.autosaveFilename.delete();
        }
    }

    @Override
    public synchronized void run() {
        if (this.interval > 0L) {
            long now = System.currentTimeMillis();
            long remainingDelay = this.lastSaved + this.interval - now;
            if (remainingDelay <= 0L) {
                if (this.drawing.isModified()) {
                    if (this.autosaveFilename == null) {
                        File filename = this.drawing.getFilename();
                        if (filename != null) {
                            this.autosaveFilename = new File(StringUtil.stripFilenameExtension((String)filename.getPath()) + ".aut");
                        }
                        if (this.autosaveFilename != null && !this.autosaveFilename.exists()) {
                            this.touch(this.autosaveFilename);
                        } else {
                            this.autosaveFilename = null;
                            for (int i = 0; i < 25 && this.autosaveFilename == null && this.interval > 0L; ++i) {
                                int autosaveNumber = (int)Math.floor(Math.random() * 100000.0);
                                File testFilename = new File("rnw" + autosaveNumber + ".aut");
                                try {
                                    if (!testFilename.createNewFile()) continue;
                                    this.autosaveFilename = testFilename;
                                    continue;
                                }
                                catch (IOException e) {
                                    this.interval = 0L;
                                    logger.debug((Object)("Autosave of drawing " + this.drawing.getName() + " cancelled: " + String.valueOf(e)));
                                }
                            }
                        }
                    }
                    if (this.interval > 0L && this.autosaveFilename != null) {
                        Rectangle rect = this.drawing.displayBox();
                        Dimension size = new Dimension(rect.width + rect.x + 200, rect.height + rect.y + 200);
                        try {
                            logger.debug((Object)("Autosaving drawing " + this.drawing.getName() + " to " + String.valueOf(this.autosaveFilename) + "..."));
                            this.saver.saveAutosaveFile(this.drawing, this.autosaveFilename, new Point(), size);
                        }
                        catch (IOException e) {
                            this.interval = 0L;
                            logger.debug((Object)("Autosave of drawing " + this.drawing.getName() + " cancelled: " + String.valueOf(e)));
                        }
                    }
                }
                this.reset();
            }
            if (this.interval > 0L) {
                Scheduler.instance().executeAt((Runnable)this, this.lastSaved + this.interval);
            }
        }
    }
}

