/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.standard.InitialAttributesMenu;
import CH.ifa.draw.standard.UndoableTool;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CreationTool
extends UndoableTool {
    private Point fAnchorPoint;
    private Figure fCreatedFigure;
    private Figure fPrototype;

    public CreationTool(DrawingEditor editor, Figure prototype) {
        super(editor);
        this.fPrototype = prototype;
    }

    protected CreationTool(DrawingEditor editor) {
        super(editor);
        this.fPrototype = null;
    }

    protected Figure getPrototype() {
        return this.fPrototype;
    }

    @Override
    public void activate() {
        super.activate();
        this.view().setCursor(Cursor.getPredefinedCursor(1));
        this.fAnchorPoint = null;
        this.fCreatedFigure = null;
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        this.fCreatedFigure = this.createFigure();
        this.fAnchorPoint = e.isControlDown() ? new Point(x, x - this.fCreatedFigure.displayBox().x + this.fCreatedFigure.displayBox().y) : new Point(x, y);
        this.fCreatedFigure.displayBox(this.fAnchorPoint, this.fAnchorPoint);
        this.view().add(this.fCreatedFigure);
        this.changesMade();
    }

    protected Figure createFigure() {
        if (this.fPrototype == null) {
            throw new HJDError("No prototype defined");
        }
        return (Figure)this.fPrototype.clone();
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        if (e.isControlDown()) {
            this.fCreatedFigure.displayBox(this.fAnchorPoint, new Point(x, x - this.fCreatedFigure.displayBox().x + this.fCreatedFigure.displayBox().y));
        } else {
            this.fCreatedFigure.displayBox(this.fAnchorPoint, new Point(x, y));
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.fCreatedFigure.isEmpty()) {
            this.drawing().remove(this.fCreatedFigure);
            this.noChangesMade();
        }
        this.fCreatedFigure = null;
        this.editor().toolDone();
    }

    protected Figure createdFigure() {
        return this.fCreatedFigure;
    }

    public Component initialAttributesMenu() {
        if (this.fPrototype instanceof AttributeFigure) {
            return new InitialAttributesMenu((AttributeFigure)this.fPrototype);
        }
        return null;
    }
}

