/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.framework.PartialSelectableFigure;
import CH.ifa.draw.standard.DragTracker;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public class ChildDragTracker
extends DragTracker {
    public static Logger logger = Logger.getLogger(ChildDragTracker.class);
    private boolean doTracking = false;
    private boolean startTracking = false;
    private Point startPoint;
    private Figure lastFigure = null;
    private ParentFigure oldParent;
    private ParentFigure newParent = null;

    public ChildDragTracker(DrawingEditor editor, ChildFigure anchor) {
        super(editor, anchor);
        this.startPoint = anchor.center();
        this.oldParent = anchor.parent();
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        this.startTracking = this.doTracking = this.fAnchorFigure != null && this.fAnchorFigure instanceof ChildFigure && this.view().selectionCount() == 1;
    }

    @Override
    protected void drag(int dx, int dy) {
        if (this.doTracking) {
            if (this.startTracking && (dx != 0 || dy != 0)) {
                this.fEditor.drawing().bringToFront(this.fAnchorFigure);
                this.startTracking = false;
            }
            this.fAnchorFigure.moveBy(dx, dy);
        } else {
            super.drag(dx, dy);
        }
    }

    private void findNewParent(MouseEvent e, int x, int y) {
        Figure figure = this.drawing().findFigureWithout(x, y, this.fAnchorFigure);
        boolean selectableFigureFound = true;
        if (figure instanceof PartialSelectableFigure) {
            PartialSelectableFigure partFig = (PartialSelectableFigure)((Object)figure);
            selectableFigureFound = false;
            if (partFig.isModifierSelectable() && e.isAltDown()) {
                selectableFigureFound = true;
            } else if (partFig.isSelectableInRegion(x, y)) {
                selectableFigureFound = true;
            }
        }
        if (selectableFigureFound && figure != this.lastFigure) {
            this.lastFigure = figure;
            if (figure instanceof ParentFigure && ((ChildFigure)this.fAnchorFigure).parent() != figure && ((ChildFigure)this.fAnchorFigure).canBeParent((ParentFigure)figure)) {
                this.newParent = (ParentFigure)figure;
                this.view().clearSelection();
                this.view().addToSelection(this.newParent);
            } else if (this.newParent != null && this.oldParent != null) {
                this.view().clearSelection();
                this.view().addToSelection(this.oldParent);
                this.newParent = null;
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        if (this.doTracking) {
            this.findNewParent(e, x, y);
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        Point endPoint;
        super.mouseUp(e, x, y);
        if (this.doTracking && this.fAnchorFigure != null && !this.startPoint.equals(endPoint = this.fAnchorFigure.center())) {
            this.findNewParent(e, x, y);
            if (this.newParent != null) {
                logger.debug((Object)("New Parent " + String.valueOf(this.newParent) + "!"));
                this.fAnchorFigure.moveBy(this.startPoint.x - endPoint.x, this.startPoint.y - endPoint.y);
                ((ChildFigure)this.fAnchorFigure).setParent(this.newParent);
            }
        }
    }
}

