/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.NoFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.io.importFormats.ImportFormatCommand;
import CH.ifa.draw.io.importFormats.ImportFormatMulti;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ImportHolderImpl
implements ImportHolder {
    public static Logger logger = Logger.getLogger(ImportHolderImpl.class);
    private List<ImportFormat> _importFormats;
    private CommandMenu _importMenu;

    public ImportHolderImpl() {
        this.setImportMenu(new CommandMenu("Import"));
        this.initImportFormatHolder();
    }

    public JMenu getImportMenu() {
        return this._importMenu;
    }

    private void initImportFormatHolder() {
        this.setImportFormats(new LinkedList<ImportFormat>());
        this.buildImportAll();
        this.loadDefaultImportFormats();
    }

    private List<ImportFormat> importFormats() {
        List<ImportFormat> result = null;
        result = this._importFormats;
        assert (result != null) : "Failure in GuiPlugin: result == null";
        return result;
    }

    private void setImportFormats(List<ImportFormat> importFormats) {
        this._importFormats = importFormats;
        assert (this.importFormats() != null) : "Failure in GuiPlugin: importFormats == null";
        assert (this.importFormats().equals(importFormats)) : "Failure in GuiPlugin: importFormats != importFormats()";
    }

    private CommandMenu importMenu() {
        CommandMenu result = null;
        result = this._importMenu;
        assert (result != null) : "Failure in GuiPlugin: result == null";
        return result;
    }

    private void setImportMenu(CommandMenu importMenu) {
        this._importMenu = importMenu;
        assert (this.importMenu() != null) : "Failure in GuiPlugin: importMenu == null";
        assert (this.importMenu().equals(importMenu)) : "Failure in GuiPlugin: importMenu != importMenu()";
    }

    private StatusDisplayer displayer() {
        DrawApplication result = DrawPlugin.getGui();
        return result;
    }

    private DrawApplication application() {
        DrawApplication result = DrawPlugin.getGui();
        return result;
    }

    private FileFilter[] fileFilterImport() {
        FileFilter[] result = null;
        LinkedList<FileFilter[]> fileFilters = new LinkedList<FileFilter[]>();
        ImportFormat[] formats = this.allImportFormats();
        int count = 0;
        for (int pos = 0; pos < formats.length; ++pos) {
            FileFilter[] filters = this.buildFileFilter(formats[pos]);
            count += filters.length;
            fileFilters.add(filters);
        }
        result = new FileFilter[++count];
        for (FileFilter[] element : fileFilters) {
            for (int pos = 0; pos < element.length; ++pos) {
                result[--count] = element[pos];
            }
        }
        result[0] = new NoFileFilter();
        return result;
    }

    private void loadDefaultImportFormats() {
    }

    private FileFilter[] buildFileFilter(ImportFormat importFormat) {
        FileFilter[] result = null;
        FileFilter filter = importFormat.fileFilter();
        LinkedList<FileFilter> list = new LinkedList<FileFilter>();
        if (filter instanceof CombinationFileFilter) {
            CombinationFileFilter comFilter = (CombinationFileFilter)filter;
            for (FileFilter fileFilter : comFilter.getFileFilters()) {
                list.add(fileFilter);
            }
        } else {
            list.add(filter);
        }
        result = new FileFilter[list.size()];
        for (int pos = 0; pos < result.length; ++pos) {
            result[pos] = (FileFilter)list.get(pos);
        }
        return result;
    }

    private void buildImportAll() {
        Command command = new Command("Import (any type)"){

            @Override
            public void execute() {
                ImportHolderImpl.this.displayer().showStatus("import...");
                File[] files = DrawPlugin.getCurrent().getIOHelper().getLoadPath(ImportHolderImpl.this.fileFilterImport());
                if (files != null) {
                    for (int posFile = 0; posFile < files.length; ++posFile) {
                        Object choice;
                        File currentFile = files[posFile];
                        LinkedList<ImportFormat> list = new LinkedList<ImportFormat>();
                        ImportFormat impFormat = null;
                        for (int posFormat = 0; posFormat < ImportHolderImpl.this.allImportFormats().length; ++posFormat) {
                            try {
                                if (!ImportHolderImpl.this.allImportFormats()[posFormat].canImport(currentFile.toURI().toURL())) continue;
                                list.add(ImportHolderImpl.this.allImportFormats()[posFormat]);
                                continue;
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                                ImportHolderImpl.this.displayer().showStatus(e.toString());
                            }
                        }
                        if (list.size() == 1) {
                            impFormat = (ImportFormat)list.get(0);
                        } else if (list.size() > 1 && (choice = JOptionPane.showInputDialog(null, "Choose", "ExportFormats", 2, null, list.toArray(), list.get(0))) != null) {
                            impFormat = (ImportFormat)choice;
                        }
                        if (impFormat != null) {
                            try {
                                ImportHolderImpl.this.loadDrawings(new URL[]{currentFile.toURI().toURL()}, impFormat);
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                                ImportHolderImpl.this.displayer().showStatus(e.toString());
                            }
                            continue;
                        }
                        ImportHolderImpl.this.displayer().showStatus("no import Format");
                    }
                }
            }
        };
        this.importMenu().add(command);
    }

    private void loadDrawings(URL[] files, ImportFormat format) {
        try {
            List<Drawing> drawings;
            if (files != null && files.length > 0 && (drawings = format.importFiles(files)) != null) {
                for (Drawing d : drawings) {
                    this.application().openDrawing(d);
                    this.displayer().showStatus("import");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.displayer().showStatus(e.toString());
        }
    }

    private void buildImportFormat(ImportFormat importFormat, CommandMenu parent) {
        ImportFormatCommand command = null;
        if (importFormat instanceof ImportFormatMulti) {
            ImportFormatMulti multi = (ImportFormatMulti)importFormat;
            ImportFormat[] formats = multi.allImportFormats();
            CommandMenu menu = new CommandMenu(multi.formatName());
            for (int pos = 0; pos < formats.length; ++pos) {
                this.buildImportFormat(formats[pos], menu);
            }
            parent.add(menu);
        } else {
            command = this.generateImportCommand(importFormat);
            parent.add(command);
        }
    }

    private ImportFormatCommand generateImportCommand(ImportFormat format) {
        ImportFormatCommand result = null;
        result = new ImportFormatCommand(format){

            @Override
            public void execute() {
                ImportHolderImpl.this.displayer().showStatus("import ...");
                File[] files = DrawPlugin.getCurrent().getIOHelper().getLoadPath(this.format().fileFilter());
                URL[] paths = new URL[files.length];
                for (int pos = 0; pos < paths.length; ++pos) {
                    try {
                        paths[pos] = files[pos].toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        ImportHolderImpl.this.displayer().showStatus(e.toString());
                    }
                }
                ImportHolderImpl.this.loadDrawings(paths, this.format());
                ImportHolderImpl.this.application().toolDone();
                ImportHolderImpl.this.displayer().showStatus("import");
            }
        };
        assert (result != null) : "Failure in GuiPlugin: result == null";
        return result;
    }

    @Override
    public void addImportFormat(ImportFormat importFormat) {
        logger.debug((Object)(String.valueOf(this.getClass()) + ": adding import format " + String.valueOf(importFormat)));
        this.importFormats().add(importFormat);
        this.buildImportFormat(importFormat, this.importMenu());
    }

    @Override
    public ImportFormat[] allImportFormats() {
        ImportFormat[] result = null;
        result = new ImportFormat[this.importFormats().size()];
        for (int pos = 0; pos < result.length; ++pos) {
            result[pos] = this.importFormats().get(pos);
        }
        assert (result != null) : "Failure in GuiPlugin: result == null";
        return result;
    }

    @Override
    public void removeImportFormat(ImportFormat format) {
        Component[] ele = this.importMenu().getMenuComponents();
        for (int pos = 0; pos < ele.length; ++pos) {
            JMenuItem item;
            if (!(ele[pos] instanceof JMenuItem) || !(item = (JMenuItem)ele[pos]).getText().equals(format.formatName())) continue;
            this.importMenu().remove(item);
        }
        this.importFormats().remove(format);
    }
}

