/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PolyLineable;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PolyLineHandle
extends LocatorHandle {
    private int fIndex;

    public PolyLineHandle(PolyLineable owner, Locator l, int index) {
        super(owner, l);
        this.fIndex = index;
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        Point p;
        PolyLineable plf = this.myOwner();
        if (e.isControlDown() && this.fIndex > 0 && this.fIndex < plf.pointCount() - 1) {
            Point prev = plf.pointAt(this.fIndex - 1);
            Point next = plf.pointAt(this.fIndex + 1);
            Point corner1 = new Point(prev.x, next.y);
            Point corner2 = new Point(next.x, prev.y);
            p = Geom.length(x, y, corner1.x, corner1.y) < Geom.length(x, y, corner2.x, corner2.y) ? corner1 : corner2;
        } else {
            p = new Point(x, y);
        }
        this.myOwner().setPointAt(p, this.fIndex);
    }

    @Override
    public void invokeStart(MouseEvent e, int x, int y, DrawingView view) {
        super.invokeStart(e, x, y, view);
        if (e.getClickCount() > 1) {
            this.myOwner().removePointAt(this.fIndex);
            view.selectionInvalidateHandles();
        }
    }

    protected int getIndex() {
        return this.fIndex;
    }

    protected PolyLineable myOwner() {
        return (PolyLineable)this.owner();
    }
}

