/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.util.Command;
import java.util.Enumeration;

public class SaveAllDrawingsCommand
extends Command {
    public SaveAllDrawingsCommand() {
        super("Save All Drawings");
    }

    @Override
    public final boolean isExecutable() {
        DrawApplication app = DrawPlugin.getGui();
        if (app == null) {
            return false;
        }
        return app.drawings().hasMoreElements();
    }

    @Override
    public final void execute() {
        Drawing drawing;
        DrawApplication app = DrawPlugin.getGui();
        Enumeration<Drawing> drawings = app.drawings();
        while (drawings.hasMoreElements()) {
            drawing = drawings.nextElement();
            if (!drawing.isStorable() || drawing.getFilename() != null) continue;
            app.showDrawingViewContainer(drawing);
            if (app.promptSaveAs(drawing)) continue;
            return;
        }
        drawings = app.drawings();
        while (drawings.hasMoreElements()) {
            drawing = drawings.nextElement();
            if (!drawing.isStorable()) continue;
            app.saveDrawing(drawing);
        }
    }
}

