/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionFigure;
import de.renew.io.WoflanFileFilter;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowTransition;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class WoflanExportFormat
extends ExportFormatAbstract {
    public WoflanExportFormat() {
        super("Woflan", (FileFilter)((Object)new WoflanFileFilter()));
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing drawing, File path) throws Exception {
        File result = null;
        if (drawing != null && path != null) {
            result = path;
            ModeReplacement.getInstance().getSimulation().buildAllShadows();
            PrintWriter p = new PrintWriter(new FileOutputStream(result));
            int cnt = 0;
            FigureEnumeration placeenumeration = drawing.figures();
            while (placeenumeration.hasMoreElements()) {
                Figure figure = placeenumeration.nextFigure();
                if (!(figure instanceof PlaceFigure)) continue;
                ShadowPlace place = (ShadowPlace)((ShadowHolder)figure).getShadow();
                Object name = place.getName();
                if (name == null) {
                    name = "P" + ++cnt;
                    place.setName((String)name);
                }
                p.println("place " + (String)name + ";");
            }
            cnt = 0;
            FigureEnumeration transenumeration = drawing.figures();
            while (transenumeration.hasMoreElements()) {
                Figure figure = transenumeration.nextFigure();
                if (!(figure instanceof TransitionFigure)) continue;
                ShadowTransition trans = (ShadowTransition)((ShadowHolder)figure).getShadow();
                Object name = trans.getName();
                if (name == null) {
                    name = "T" + ++cnt;
                    trans.setName((String)name);
                }
                ArrayList<String> inarcs = new ArrayList<String>();
                ArrayList<String> outarcs = new ArrayList<String>();
                for (Object elem : trans.elements()) {
                    if (!(elem instanceof ShadowInscription)) continue;
                    ShadowInscription shadowInscription = (ShadowInscription)elem;
                    if (!shadowInscription.inscr.startsWith(":new(")) continue;
                    inarcs.add("pinit");
                }
                FigureEnumeration arcenumeration = drawing.figures();
                while (arcenumeration.hasMoreElements()) {
                    figure = arcenumeration.nextFigure();
                    if (!(figure instanceof ArcConnection)) continue;
                    ArcConnection ac = (ArcConnection)figure;
                    ShadowArc arc = (ShadowArc)ac.getShadow();
                    if (arc.transition != trans) continue;
                    String placename = arc.place.getName();
                    if (arc.shadowArcType == 2 || arc.shadowArcType == 0) {
                        inarcs.add(placename);
                        outarcs.add(placename);
                        continue;
                    }
                    if (arc.shadowArcType != 1) continue;
                    if (arc.placeToTransition) {
                        inarcs.add(placename);
                        continue;
                    }
                    outarcs.add(placename);
                }
                p.println("trans " + (String)name + this.placeVector(inarcs, " in") + this.placeVector(outarcs, " out") + ";");
            }
            p.close();
        }
        assert (result != null) : "Failure in WoflanExportFormat: result == null";
        return result;
    }

    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in WoflanExportFormat: result == null";
        return result;
    }

    private String placeVector(List<String> places, String title) {
        StringBuilder output = new StringBuilder();
        if (!places.isEmpty()) {
            output.append(title);
            for (int i = places.size() - 1; i >= 0; --i) {
                output.append(" ").append(places.get(i));
            }
        }
        return output.toString();
    }

    public boolean canExportDrawing(Drawing drawing) {
        return drawing instanceof CPNDrawing;
    }
}

