/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.nin;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.DrawingHelper;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.InscribableFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.nin.TemplateBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import org.apache.log4j.Logger;

public class SystemNetBuilder {
    public static final String formalismCompilerName = "P/T Net in Net Compiler";
    private static final Logger logger = Logger.getLogger(SystemNetBuilder.class);
    private final Map<Integer, Set<String>> channelsForOption;
    final boolean[] options;
    int downMover = 0;
    int numSyncTransitions = 0;
    int rightMover = 0;
    private CPNDrawing systemNet;
    private Collection<TransitionFigure> transitions;
    private Collection<PlaceFigure> places;
    private Collection<TextFigure> texts;
    private TransitionFigure templateSyncTransition;
    private CPNTextFigure templateSyncInscription;

    public SystemNetBuilder(Map<Drawing, Integer> drawingsToConsider, boolean[] options, Map<Integer, Set<String>> channelsForOption, DefaultListModel<String> customSynchronizations) {
        this.options = options;
        this.channelsForOption = channelsForOption;
        CPNDrawing template = TemplateBuilder.buildSystemNetTemplate();
        this.buildSystemNet(template, drawingsToConsider, customSynchronizations);
    }

    private void buildSystemNet(CPNDrawing template, Map<Drawing, Integer> drawingsToConsider, DefaultListModel<String> customSynchronizations) {
        try {
            this.systemNet = (CPNDrawing)DrawingHelper.cloneDrawing((Drawing)template);
        }
        catch (Exception e) {
            logger.error((Object)"Could not clone template net.");
            return;
        }
        this.setFigureFields(this.systemNet);
        TextFigure createReferencesText = this.getCreateText();
        TextFigure moveReferencesArcText = this.getRefArcText();
        this.setTextsForCreatingAndMovingAllConsideredNets(createReferencesText, moveReferencesArcText, drawingsToConsider);
        this.buildTransitionsForAllUplinksInNets();
        for (int i = 0; i < customSynchronizations.getSize(); ++i) {
            this.addDownlinkTransitionForInscriptionToSystem(customSynchronizations.get(i));
        }
        this.systemNet.setName("SystemNet");
        this.systemNet.checkDamage();
    }

    private void setTextsForCreatingAndMovingAllConsideredNets(TextFigure createReferencesText, TextFigure moveReferencesArcText, Map<Drawing, Integer> drawingsToConsider) {
        if (createReferencesText != null && moveReferencesArcText != null) {
            String createText = "";
            String moveText = "";
            for (Drawing drawing : drawingsToConsider.keySet()) {
                for (int i = 0; i < drawingsToConsider.get(drawing); ++i) {
                    String netVariableName = drawing.getName().toLowerCase() + i;
                    createText = createText.concat(netVariableName + ":new " + drawing.getName() + ";\n");
                    moveText = moveText.concat(netVariableName + ";");
                }
            }
            createReferencesText.setText(createText);
            moveReferencesArcText.setText(moveText);
        }
    }

    private void buildTransitionsForAllUplinksInNets() {
        int numOfCommunicationPartners;
        String[] nets;
        if (this.options[0]) {
            nets = new String[]{"netA", "netB"};
            numOfCommunicationPartners = 2;
            for (String channel : this.channelsForOption.get(0)) {
                this.addDownlinkTransitionForChannelToSystem(nets, channel, numOfCommunicationPartners);
            }
        }
        if (this.options[1]) {
            nets = new String[]{"netA"};
            numOfCommunicationPartners = 2;
            for (String channel : this.channelsForOption.get(1)) {
                this.addDownlinkTransitionForChannelToSystem(nets, channel, numOfCommunicationPartners);
            }
        }
        if (this.options[2]) {
            nets = new String[]{"netA"};
            numOfCommunicationPartners = 1;
            for (String channel : this.channelsForOption.get(2)) {
                this.addDownlinkTransitionForChannelToSystem(nets, channel, numOfCommunicationPartners);
            }
        }
        this.removeTemplateFigures();
    }

    private void addDownlinkTransitionForChannelToSystem(String[] nets, String channel, int downlinksOnTransition) {
        TransitionFigure newTransition = (TransitionFigure)this.templateSyncTransition.clone();
        CPNTextFigure newInscription = (CPNTextFigure)this.templateSyncInscription.clone();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < downlinksOnTransition; ++i) {
            text.append("this:getReference(").append(nets[i % nets.length]).append(");\n");
            text.append(nets[i % nets.length]).append(channel).append(";\n");
        }
        newInscription.setText(text.toString());
        this.addInscription(newTransition, newInscription);
        this.moveNewFigure(newTransition);
        this.systemNet.add(newTransition);
    }

    private void addDownlinkTransitionForInscriptionToSystem(String inscription) {
        TransitionFigure newTransition = (TransitionFigure)this.templateSyncTransition.clone();
        CPNTextFigure newInscription = (CPNTextFigure)this.templateSyncInscription.clone();
        newInscription.setText(inscription);
        this.addInscription(newTransition, newInscription);
        this.moveNewFigure(newTransition);
        this.systemNet.add(newTransition);
    }

    private void moveNewFigure(TransitionFigure newTransition) {
        int pixelsToMoveDown = 80;
        int pixelsToMoveRight = 165;
        newTransition.moveBy(this.rightMover, this.downMover);
        ++this.numSyncTransitions;
        if (this.numSyncTransitions < 3) {
            this.downMover += pixelsToMoveDown;
        } else if (this.numSyncTransitions == 3) {
            this.downMover = 0;
            this.rightMover += pixelsToMoveRight;
        } else if (this.numSyncTransitions < 5) {
            this.downMover += pixelsToMoveDown;
        } else if (this.numSyncTransitions % 6 == 0) {
            this.rightMover += pixelsToMoveRight;
            this.downMover = -3 * pixelsToMoveDown;
        } else {
            this.downMover += pixelsToMoveDown;
        }
    }

    private void addInscription(InscribableFigure parent, CPNTextFigure child) {
        this.systemNet.add(child);
        parent.addChild((ChildFigure)child);
        child.setParent(parent);
    }

    private TextFigure getRefArcText() {
        for (TextFigure text : this.texts) {
            if (!this.figureHoldsText((Figure)text, "netA;netB")) continue;
            return text;
        }
        return null;
    }

    private TextFigure getCreateText() {
        for (TextFigure text : this.texts) {
            if (!this.figureHoldsText((Figure)text, ".*:new .*")) continue;
            return text;
        }
        return null;
    }

    private void setFigureFields(CPNDrawing drawing) {
        this.transitions = new ArrayList<TransitionFigure>();
        this.places = new ArrayList<PlaceFigure>();
        this.texts = new ArrayList<TextFigure>();
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure fig = figureEnumeration.nextFigure();
            if (fig instanceof TransitionFigure) {
                TransitionFigure transitionFigure = (TransitionFigure)fig;
                this.transitions.add(transitionFigure);
                continue;
            }
            if (fig instanceof PlaceFigure) {
                PlaceFigure placeFigure = (PlaceFigure)fig;
                this.places.add(placeFigure);
                continue;
            }
            if (!(fig instanceof TextFigure)) continue;
            TextFigure textFigure = (TextFigure)fig;
            this.texts.add(textFigure);
        }
        this.setTemplateSyncFigures();
    }

    private void setTemplateSyncFigures() {
        for (TransitionFigure transition : this.transitions) {
            FigureEnumeration children = transition.children();
            while (children.hasMoreElements()) {
                Figure fig = children.nextFigure();
                if (!this.figureHoldsText(fig, ".*:sync().*")) continue;
                this.templateSyncTransition = transition;
                this.templateSyncInscription = (CPNTextFigure)fig;
            }
        }
    }

    private void removeTemplateFigures() {
        this.systemNet.remove(this.templateSyncTransition);
        this.systemNet.remove(this.templateSyncInscription);
    }

    public Integer getCreateTransitionID() {
        for (TransitionFigure transition : this.transitions) {
            FigureEnumeration children = transition.children();
            while (children.hasMoreElements()) {
                Figure fig = children.nextFigure();
                if (!this.figureHoldsText(fig, ".*:new .*")) continue;
                return transition.getID();
            }
        }
        return null;
    }

    public Integer getReferencePlaceID() {
        for (PlaceFigure place : this.places) {
            FigureEnumeration children = place.children();
            while (children.hasMoreElements()) {
                Figure fig = children.nextFigure();
                if (!this.figureHoldsText(fig, "NetReferences")) continue;
                return place.getID();
            }
        }
        return null;
    }

    private boolean figureHoldsText(Figure fig, String regex) {
        if (fig instanceof CPNTextFigure) {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(((CPNTextFigure)fig).getText());
            return m.find();
        }
        return false;
    }

    public CPNDrawing getSystemNet() {
        return this.systemNet;
    }
}

