/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.FigureAttributes;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.AWTSynchronizedUpdate;
import de.renew.gui.MultipleTokenFigure;
import de.renew.gui.SimpleCompositeFigure;
import de.renew.remote.EventListener;
import de.renew.remote.MarkingAccessor;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.RemoteEventForwarder;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TokenCountsAccessor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TokenBagFigure
extends SimpleCompositeFigure
implements ChildFigure,
EventListener {
    private static final Logger logger = Logger.getLogger(TokenBagFigure.class);
    private static final int BORDER = 3;
    private static final int SEPARATOR = 1;
    private OffsetLocator fLocator = null;
    private Drawing lockDrawing;
    private AbstractFigure figure;
    private PlaceInstanceAccessor placeInstance;
    private RemoteEventForwarder forwarder;
    private int cacheMult = -1;
    private int cacheTestMult = -1;
    private TextFigure cardFigure;
    private FigureAttributes attributes;
    private int markingAppearance = -1;
    private AWTSynchronizedUpdate updateTask = null;

    public TokenBagFigure() {
    }

    public TokenBagFigure(Drawing lockDrawing, AbstractFigure figure, PlaceInstanceAccessor pi) {
        this(lockDrawing, figure, pi, 1);
    }

    public TokenBagFigure(Drawing lockDrawing, AbstractFigure figure, PlaceInstanceAccessor pi, int markingAppearance) {
        this.placeInstance = pi;
        this.lockDrawing = lockDrawing;
        this.cardFigure = new TextFigure();
        this.cardFigure.setReadOnly(true);
        this.cardFigure.setAttribute("FontStyle", (Object)2);
        this.attributes = new FigureAttributes();
        if (figure != null) {
            this.setParent((ParentFigure)figure);
        }
        this.setMarkingAppearance(markingAppearance);
        try {
            this.forwarder = new RemoteEventForwarder((EventListener)this);
            this.placeInstance.addRemoteEventListener((RemoteEventListener)this.forwarder);
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Vector<Handle> basicHandles() {
        Vector<Handle> handles = super.basicHandles();
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northWest()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northEast()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southWest()));
        handles.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southEast()));
        return handles;
    }

    public boolean canBeParent(ParentFigure p) {
        return p instanceof AbstractFigure && (this.figure == null || this.figure == p);
    }

    private void unsetParent() {
        if (this.figure != null) {
            this.figure.removeChild((ChildFigure)this);
            this.figure = null;
        }
    }

    public boolean setParent(ParentFigure figure) {
        if (!this.canBeParent(figure)) {
            return false;
        }
        if (this.figure == figure) {
            return true;
        }
        this.unsetParent();
        this.figure = (AbstractFigure)figure;
        if (figure == null) {
            this.fLocator = null;
        } else {
            figure.addChild((ChildFigure)this);
            if (this.fLocator != null) {
                this.fLocator.setBase(figure.connectedTextLocator((Figure)this));
            } else {
                this.fLocator = new OffsetLocator(figure.connectedTextLocator((Figure)this));
            }
            this.updateLocation();
        }
        return true;
    }

    public ParentFigure parent() {
        return this.figure;
    }

    @Override
    protected void layout() {
        Point partOrigin = this.displayBox().getLocation();
        partOrigin.translate(3, 3);
        Dimension extent = new Dimension(0, 0);
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            Dimension partExtent = f.size();
            Point corner = new Point(partOrigin.x + partExtent.width, partOrigin.y + partExtent.height);
            f.basicDisplayBox(partOrigin, corner);
            extent.width = Math.max(extent.width, partExtent.width);
            extent.height += partExtent.height + 1;
            partOrigin.y += partExtent.height + 1;
        }
        this.fDisplayBox.width = extent.width + 6;
        this.fDisplayBox.height = extent.height - 1 + 6;
        this.updateLocation();
        super.layout();
    }

    @Override
    protected boolean needsLayout() {
        Dimension extent = new Dimension(0, 5);
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            extent.width = Math.max(extent.width, f.size().width);
            extent.height += f.size().height + 1;
        }
        extent.width += 6;
        return !extent.equals(this.fDisplayBox.getSize());
    }

    @Override
    public void moveBy(int x, int y) {
        super.moveBy(x, y);
        if (this.fLocator != null) {
            this.fLocator.moveBy(x, y);
        }
    }

    public void updateLocation() {
        if (this.fLocator != null) {
            Point p = this.fLocator.locate((Figure)this.figure);
            Rectangle box = this.displayBox();
            p.x -= box.x + box.width / 2;
            p.y -= box.y + box.height / 2;
            if (p.x != 0 || p.y != 0) {
                this.willChange();
                this.basicMoveBy(p.x, p.y);
                this.changed();
            }
        }
    }

    public void update() {
        if (this.updateTask == null) {
            this.updateTask = new AWTSynchronizedUpdate(() -> this.executeUpdate());
        }
        this.updateTask.scheduleUpdate();
    }

    private void executeUpdate() {
        Drawing theLockDrawing = this.lockDrawing;
        if (theLockDrawing == null) {
            return;
        }
        if (this.lockDrawing == null) {
            return;
        }
        if (this.markingAppearance == 1) {
            this.updateCardFigure();
        } else {
            this.updateTokenFigures();
        }
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)this));
        }
    }

    protected void updateCardFigure() {
        try {
            TokenCountsAccessor tokenCounts = this.placeInstance.getTokenCounts();
            int newTestMult = tokenCounts.getTestedTokenCount();
            int newMult = tokenCounts.getFreeTokenCount() + newTestMult;
            if (newMult != this.cacheMult || newTestMult != this.cacheTestMult) {
                this.cacheMult = newMult;
                this.cacheTestMult = newTestMult;
                if (newTestMult > 0) {
                    if (newMult > 0) {
                        this.cardFigure.setText(newMult + "(" + newTestMult + ")");
                    } else {
                        this.cardFigure.setText("(" + newTestMult + ")");
                    }
                } else if (newMult > 0) {
                    this.cardFigure.setText(String.valueOf(newMult));
                } else {
                    this.cardFigure.setText(" ");
                }
            }
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateTokenFigures() {
        this.removeAll();
        this.willChange();
        try {
            MarkingAccessor marking = this.placeInstance.getMarking();
            boolean expanded = this.markingAppearance == 3;
            int distinctTokenCount = marking.getDistinctTokenCount();
            for (int i = 0; i < distinctTokenCount; ++i) {
                ObjectAccessor token = marking.getToken(i);
                boolean isTested = marking.getTokenTested(i);
                double[] times = marking.getTokenTimes(i);
                int[] mults = marking.getTokenTimeMultiplicities(i);
                for (int j = 0; j < times.length; ++j) {
                    double time = times[j];
                    int mult = mults[j];
                    boolean showTested = isTested && time == marking.getCurrentTime();
                    MultipleTokenFigure tokenFigure = new MultipleTokenFigure(mult, showTested, time, token, expanded);
                    Enumeration attrenumeration = this.attributes.definedAttributes();
                    while (attrenumeration.hasMoreElements()) {
                        String attribute = (String)attrenumeration.nextElement();
                        tokenFigure.setAttribute(attribute, this.attributes.get(attribute));
                    }
                    this.add((Figure)tokenFigure);
                }
            }
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.layout();
        this.changed();
    }

    public void release() {
        Drawing theDrawing = this.lockDrawing;
        if (theDrawing == null) {
            return;
        }
        if (this.lockDrawing == null) {
            // empty if block
        }
        if (this.placeInstance != null) {
            try {
                this.placeInstance.removeRemoteEventListener((RemoteEventListener)this.forwarder);
            }
            catch (RemoteException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.placeInstance = null;
        }
        this.unsetParent();
        this.lockDrawing = null;
        this.removeAll();
        super.release();
    }

    public String toString() {
        if (this.placeInstance == null) {
            return "Detached TokenBagFigure@" + System.identityHashCode((Object)this);
        }
        StringBuilder output = new StringBuilder().append('{');
        try {
            MarkingAccessor marking = this.placeInstance.getMarking();
            int distinctTokenCount = marking.getDistinctTokenCount();
            for (int i = 0; i < distinctTokenCount; ++i) {
                ObjectAccessor token = marking.getToken(i);
                int mult = marking.getTokenFreeCount(i);
                boolean isTested = marking.getTokenTested(i);
                output.append(MultipleTokenFigure.getMultString(mult, isTested));
                output.append(token == null ? "null" : token.asString());
                if (i >= distinctTokenCount - 1) continue;
                output.append(", ");
            }
            output.append('}');
            return output.toString();
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public boolean wantSynchronousNotification() {
        return false;
    }

    public void setMarkingAppearance(int markingAppearance) {
        if (this.markingAppearance != markingAppearance && markingAppearance != 0) {
            this.willChange();
            this.markingAppearance = markingAppearance;
            if (markingAppearance == 1) {
                this.removeAll();
                this.add((Figure)this.cardFigure);
            }
            this.update();
            this.layout();
            this.changed();
        }
    }

    @Override
    public boolean inspect(DrawingView view, boolean alternate) {
        boolean done = super.inspect(view, alternate);
        if (alternate && !done) {
            view.clearSelection();
            int newMA = this.markingAppearance == 1 ? (this.figure == null ? 3 : 2) : 1;
            this.setAttribute("MarkingAppearance", newMA);
            view.addToSelection((Figure)this);
        }
        return done;
    }

    protected PlaceInstanceAccessor getPlaceInstance() {
        return this.placeInstance;
    }

    @Override
    public void update(FigureChangeEvent e) {
        this.updateLocation();
        super.update(e);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name.equals("MarkingAppearance")) {
            if (this.figure != null) {
                this.figure.setAttribute(name, value);
            } else {
                this.setMarkingAppearance((Integer)value);
            }
        } else {
            if (this.markingAppearance != 1) {
                this.attributes.set(name, value);
            }
            super.setAttribute(name, value);
        }
    }

    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration superDep = super.getFiguresWithDependencies();
        Vector<AbstractFigure> myDep = new Vector<AbstractFigure>(1);
        myDep.addElement(this.figure);
        return new MergedFigureEnumerator(superDep, (FigureEnumeration)new FigureEnumerator(myDep));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("TokenBagFigure is not serializable!");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.figure != null) {
            this.figure.addChild((ChildFigure)this);
        }
    }

    protected TextFigure getCardFigure() {
        return this.cardFigure;
    }

    protected int getCachedMultiplicity() {
        return this.cacheMult;
    }

    protected int getCachedTestMultiplicty() {
        return this.cacheTestMult;
    }

    protected void setCachedMultiplicity(int cacheMult) {
        this.cacheMult = cacheMult;
    }

    protected void setCachedTestMultiplicty(int cacheTestMult) {
        this.cacheTestMult = cacheTestMult;
    }
}

