/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.util.ColorMap;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.DoubleArcConnection;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.HollowDoubleArcConnection;
import de.renew.gui.InhibitorConnection;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowDeclarationNode;
import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.ShadowNode;
import de.renew.shadow.ShadowTransition;
import de.renew.util.ObjectInputStreamUsingBottomLoader;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ShadowNetSystemRenderer {
    private static final Logger logger = Logger.getLogger(ShadowNetSystemRenderer.class);

    public static ShadowNetSystem readShadowNetSystem(URL location) {
        ShadowNetSystem netSystem = null;
        try (InputStream stream = location.openStream();){
            ObjectInputStreamUsingBottomLoader input = new ObjectInputStreamUsingBottomLoader(stream);
            netSystem = (ShadowNetSystem)input.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("Could not load net system from " + String.valueOf(location) + "."));
        }
        return netSystem;
    }

    public static List<Drawing> render(URL location) {
        ShadowNetSystem netSystem = ShadowNetSystemRenderer.readShadowNetSystem(location);
        if (netSystem == null) {
            return new ArrayList<Drawing>();
        }
        Set nets = netSystem.elements();
        ArrayList<Drawing> drawings = new ArrayList<Drawing>(nets.size());
        for (ShadowNet net : nets) {
            drawings.add(new ShadowNetRenderer((ShadowNet)net).drawing);
        }
        return drawings;
    }

    private static class ShadowNetRenderer {
        final CPNDrawing drawing = new CPNDrawing();
        private final Hashtable<ShadowInscribable, ParentFigure> lookup = new Hashtable();
        private final Point loc = new Point(100, 20);

        ShadowNetRenderer(ShadowNet net) {
            this.render(net);
        }

        private void render(ShadowNet net) {
            this.drawing.setName(net.getName());
            for (ShadowNetElement element : net.elements()) {
                if (element instanceof ShadowNode) {
                    ShadowNode shadowNode = (ShadowNode)element;
                    this.renderNode(shadowNode);
                }
                if (!(element instanceof ShadowDeclarationNode)) continue;
                ShadowDeclarationNode declarationNode = (ShadowDeclarationNode)element;
                this.renderDeclarationNode(declarationNode);
            }
            for (ShadowNetElement element : net.elements()) {
                if (!(element instanceof ShadowArc)) continue;
                ShadowArc shadowArc = (ShadowArc)element;
                this.renderArc(shadowArc);
            }
            for (ShadowNetElement element : net.elements()) {
                if (!(element instanceof ShadowInscription)) continue;
                ShadowInscription shadowInscription = (ShadowInscription)element;
                this.renderInscription(shadowInscription);
            }
        }

        private void renderDeclarationNode(ShadowDeclarationNode declNode) {
            DeclarationFigure createdFig = new DeclarationFigure();
            createdFig.setText(declNode.inscr);
            this.drawing.add(createdFig);
        }

        private void renderNode(ShadowNode node) {
            Dimension dim;
            FigureWithHighlight createdFig;
            if (node instanceof ShadowTransition) {
                createdFig = new TransitionFigure();
                dim = TransitionFigure.defaultDimension();
            } else {
                createdFig = new PlaceFigure();
                dim = PlaceFigure.defaultDimension();
            }
            this.drawing.add((Figure)createdFig);
            if (node.getName() != null) {
                CPNTextFigure nameFig = new CPNTextFigure(2);
                nameFig.setText(node.getName());
                int nameWidth = nameFig.displayBox().width;
                if (nameWidth + 8 > dim.width) {
                    dim.width = nameWidth + 8;
                }
                this.drawing.add(nameFig);
                nameFig.setParent((ParentFigure)createdFig);
            }
            Point rightLower = new Point(dim.width, dim.height);
            createdFig.displayBox(new Point(), rightLower);
            createdFig.moveBy(this.loc.x, this.loc.y);
            this.lookup.put((ShadowInscribable)node, (ParentFigure)createdFig);
            createdFig.setAttribute("TraceMode", node.getTrace());
        }

        private void renderArc(ShadowArc arc) {
            int shadowArcType = arc.shadowArcType;
            Figure startFig = (Figure)this.lookup.get(arc.place);
            Figure endFig = (Figure)this.lookup.get(arc.transition);
            if (!arc.placeToTransition) {
                Figure helpFig = startFig;
                startFig = endFig;
                endFig = helpFig;
            }
            ArcConnection arcFig = switch (shadowArcType) {
                case 0, 1, 2 -> new ArcConnection(shadowArcType);
                case 3 -> new InhibitorConnection();
                case 4 -> new DoubleArcConnection();
                case 5 -> new HollowDoubleArcConnection();
                default -> throw new RuntimeException("Bad shadow arc type.");
            };
            arcFig.startPoint(0, 0);
            arcFig.endPoint(0, 0);
            this.drawing.add(arcFig);
            this.lookup.put((ShadowInscribable)arc, arcFig);
            arcFig.connectStart(startFig.connectorAt(0, 0));
            arcFig.connectEnd(endFig.connectorAt(0, 0));
            arcFig.updateConnection();
            arcFig.setAttribute("TraceMode", arc.getTrace());
        }

        private void renderInscription(ShadowInscription inscription) {
            CPNTextFigure inscrFig = new CPNTextFigure(1);
            inscrFig.setText(inscription.inscr);
            ParentFigure parent = this.lookup.get(inscription.inscribable);
            this.drawing.add(inscrFig);
            inscrFig.setParent(parent);
            inscrFig.setAttribute("TraceMode", inscription.getTrace());
            if (parent instanceof ArcConnection) {
                inscrFig.setAttribute("FillColor", ColorMap.BACKGROUND);
            }
        }
    }
}

