/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;

public class GraphLayout
extends FigureChangeAdapter {
    public static final double DEFAULT_LENGTH_FACTOR = 1.0;
    public static final double DEFAULT_REPULSION_STRENGTH = 2.0;
    public static final double DEFAULT_REPULSION_LIMIT = 400.0;
    public static final double DEFAULT_SPRING_STRENGTH = 0.05;
    public static final double DEFAULT_TORQUE_STRENGTH = 0.25;
    public static final double DEFAULT_FRICTION_FACTOR = 0.75;
    public double lengthFactor = 1.0;
    public double repulsionStrength = 2.0;
    public double repulsionLimit = 400.0;
    public double springStrength = 0.05;
    public double torqueStrength = 0.25;
    public double frictionFactor = 0.75;
    final int repulsionType = 0;
    private Hashtable<Figure, GraphNode> nodes = new Hashtable();
    private Hashtable<ConnectionFigure, Double> edges = new Hashtable();

    private GraphNode getGraphNode(Figure node) {
        return this.nodes.get(node);
    }

    private double len(ConnectionFigure edge) {
        return this.edges.get(edge) * this.lengthFactor;
    }

    public void addNode(Figure node) {
        this.nodes.put(node, new GraphNode(node));
        node.addFigureChangeListener((FigureChangeListener)this);
    }

    public void addEdge(ConnectionFigure edge, int addlen) {
        Dimension d1 = edge.start().owner().size();
        Dimension d2 = edge.end().owner().size();
        int len = Math.max(d1.width, d1.height) / 2 + Math.max(d2.width, d2.height) / 2 + addlen;
        this.edges.put(edge, Double.valueOf(len));
    }

    public synchronized void relax() {
        if (this.nodes == null) {
            return;
        }
        Enumeration<ConnectionFigure> edgeEnum = this.edges.keys();
        while (edgeEnum.hasMoreElements()) {
            ConnectionFigure e = edgeEnum.nextElement();
            double targetlen = this.len(e);
            GraphNode from = this.getGraphNode(e.start().owner());
            GraphNode to = this.getGraphNode(e.end().owner());
            double vx = to.x - from.x;
            double vy = to.y - from.y;
            double len = Math.sqrt(vx * vx + vy * vy);
            if (!(len > 0.0)) continue;
            double f = this.springStrength * (targetlen - len) / len;
            double dx = f * vx;
            double dy = f * vy;
            double phi = Math.atan2(vx, vy);
            double dir = -Math.sin(4.0 * phi);
            to.dx += (dx += this.torqueStrength * vy * dir / len);
            to.dy += (dy += -this.torqueStrength * vx * dir / len);
            from.dx += -dx;
            from.dy += -dy;
        }
        Enumeration<GraphNode> nodeEnum1 = this.nodes.elements();
        while (nodeEnum1.hasMoreElements()) {
            GraphNode n1 = nodeEnum1.nextElement();
            double dx = 0.0;
            double dy = 0.0;
            Enumeration<GraphNode> nodeEnum2 = this.nodes.elements();
            while (nodeEnum2.hasMoreElements()) {
                GraphNode n2 = nodeEnum2.nextElement();
                if (n1 == n2) continue;
                double vx = n1.x - n2.x;
                double vy = n1.y - n2.y;
                double lensqr = vx * vx + vy * vy;
                double len = Math.sqrt(lensqr);
                if (len == 0.0) {
                    dx += this.repulsionStrength * Math.random();
                    dy += this.repulsionStrength * Math.random();
                    continue;
                }
                if (!(len < this.repulsionLimit)) continue;
                vx /= this.repulsionLimit;
                vy /= this.repulsionLimit;
                len /= this.repulsionLimit;
                double f = switch (0) {
                    case 0 -> 0.5 * (1.0 - len) / len;
                    case 1 -> 1.0 - len;
                    case 2 -> 2.0 * (1.0 - len) * (1.0 - len);
                    default -> 0.0;
                };
                dx += (f *= this.repulsionStrength) * vx;
                dy += f * vy;
            }
            n1.dx += dx;
            n1.dy += dy;
        }
        Enumeration<Figure> nodeEnum = this.nodes.keys();
        while (nodeEnum.hasMoreElements()) {
            Figure node = nodeEnum.nextElement();
            GraphNode n = this.getGraphNode(node);
            if (!Boolean.TRUE.equals(node.getAttribute("Location"))) {
                n.x += Math.max(-5.0, Math.min(5.0, n.dx));
                n.y += Math.max(-5.0, Math.min(5.0, n.dy));
                Point c = node.center();
                node.moveBy((int)Math.round(n.x) - c.x, (int)Math.round(n.y) - c.y);
                if (n.x < 0.0) {
                    n.x = 0.0;
                }
                if (n.y < 0.0) {
                    n.y = 0.0;
                }
            }
            n.dx *= this.frictionFactor;
            n.dy *= this.frictionFactor;
        }
    }

    public synchronized void figureChanged(FigureChangeEvent e) {
        Figure node;
        if (this.nodes != null && this.nodes.containsKey(node = e.getFigure())) {
            this.getGraphNode(node).update();
        }
    }

    public void remove() {
        if (this.nodes != null) {
            Enumeration<Figure> nodeEnum = this.nodes.keys();
            while (nodeEnum.hasMoreElements()) {
                Figure node = nodeEnum.nextElement();
                node.removeFigureChangeListener((FigureChangeListener)this);
            }
            this.nodes = null;
            this.edges = null;
        }
    }

    synchronized void randomInit(double x, double y, double width, double height) {
        if (this.nodes != null) {
            Enumeration<GraphNode> nodeEnum = this.nodes.elements();
            while (nodeEnum.hasMoreElements()) {
                GraphNode node = nodeEnum.nextElement();
                node.x = x + Math.random() * width;
                node.y = y + Math.random() * height;
            }
        }
    }

    synchronized void moveBy(int dx, int dy) {
        if (this.nodes != null) {
            Enumeration<Figure> figEnum = this.nodes.keys();
            while (figEnum.hasMoreElements()) {
                figEnum.nextElement().moveBy(dx, dy);
            }
        }
    }

    private static class GraphNode {
        double x = 0.0;
        double y = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        final Figure node;

        GraphNode(Figure node) {
            this.node = node;
            this.update();
        }

        void update() {
            Point p = this.node.center();
            if (Math.abs((long)p.x - Math.round(this.x)) > 1L || Math.abs((long)p.y - Math.round(this.y)) > 1L) {
                this.x = p.x;
                this.y = p.y;
            }
        }
    }
}

