/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.io.Serializable;

public class ID
implements Serializable {
    private int[] seq;
    private int hash;

    private ID(int[] seq) {
        this.seq = seq;
        this.hash = 637;
        for (int i = 0; i < seq.length; ++i) {
            this.hash = this.hash * 59 + seq[i];
        }
    }

    public static ID create(int num) {
        return new ID(new int[]{num});
    }

    public static ID create(int num1, int num2) {
        return new ID(new int[]{num1, num2});
    }

    public static ID create(int num1, int num2, int num3) {
        return new ID(new int[]{num1, num2, num3});
    }

    public static ID create(int[] seq) {
        return new ID((int[])seq.clone());
    }

    public ID appending(int num) {
        int[] newSeq = new int[this.seq.length + 1];
        for (int i = 0; i < this.seq.length; ++i) {
            newSeq[i] = this.seq[i];
        }
        newSeq[this.seq.length] = num;
        return new ID(newSeq);
    }

    public ID appending(ID id) {
        return this.appending(id.seq);
    }

    public ID appending(int[] app) {
        int i;
        int[] newSeq = new int[this.seq.length + app.length];
        for (i = 0; i < this.seq.length; ++i) {
            newSeq[i] = this.seq[i];
        }
        for (i = 0; i < app.length; ++i) {
            newSeq[i + this.seq.length] = this.seq[i];
        }
        return new ID(newSeq);
    }

    public ID clipped() {
        if (this.seq.length == 0) {
            throw new RuntimeException("Cannot clip: ID already empty.");
        }
        int[] newSeq = new int[this.seq.length - 1];
        for (int i = 0; i < this.seq.length - 1; ++i) {
            newSeq[i] = this.seq[i];
        }
        return new ID(newSeq);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ID) {
            ID that = (ID)obj;
            if (that.seq.length == this.seq.length) {
                for (int i = 0; i < this.seq.length; ++i) {
                    if (that.seq[i] == this.seq[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.seq.length; ++i) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(this.seq[i]);
        }
        return buf.toString();
    }
}

