/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CDockableLocationEvent;
import bibliothek.gui.dock.common.event.CDockableLocationListener;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.event.CDockableStateListener;
import bibliothek.gui.dock.common.event.CDoubleClickListener;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CKeyboardListener;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.event.CVetoFocusListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class CListenerCollection {
    private List<CDockableStateListener> stateListeners = new ArrayList<CDockableStateListener>();
    private CDockableStateListener stateListener = new CDockableStateListener(){

        public void extendedModeChanged(CDockable dockable, ExtendedMode mode) {
            for (CDockableStateListener listener : CListenerCollection.this.getCDockableStateListeners()) {
                listener.extendedModeChanged(dockable, mode);
            }
        }

        public void visibilityChanged(CDockable dockable) {
            for (CDockableStateListener listener : CListenerCollection.this.getCDockableStateListeners()) {
                listener.visibilityChanged(dockable);
            }
        }
    };
    private List<CDockablePropertyListener> propertyListeners = new ArrayList<CDockablePropertyListener>();
    private CDockablePropertyListener propertyListener = new CDockablePropertyListener(){

        public void actionChanged(CDockable dockable, String key, CAction oldAction, CAction newAction) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.actionChanged(dockable, key, oldAction, newAction);
            }
        }

        public void closeableChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.closeableChanged(dockable);
            }
        }

        public void externalizableChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.externalizableChanged(dockable);
            }
        }

        public void maximizableChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.maximizableChanged(dockable);
            }
        }

        public void minimizableChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.minimizableChanged(dockable);
            }
        }

        public void normalizeableChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.normalizeableChanged(dockable);
            }
        }

        public void minimizeSizeChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.minimizeSizeChanged(dockable);
            }
        }

        public void stickyChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.stickyChanged(dockable);
            }
        }

        public void stickySwitchableChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.stickySwitchableChanged(dockable);
            }
        }

        public void resizeLockedChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.resizeLockedChanged(dockable);
            }
        }

        public void titleShownChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.titleShownChanged(dockable);
            }
        }

        public void singleTabShownChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.singleTabShownChanged(dockable);
            }
        }

        public void enabledChanged(CDockable dockable) {
            for (CDockablePropertyListener listener : CListenerCollection.this.getCDockablePropertyListeners()) {
                listener.enabledChanged(dockable);
            }
        }
    };
    private List<CFocusListener> focusListeners = new ArrayList<CFocusListener>();
    private CFocusListener focusListener = new CFocusListener(){

        public void focusGained(CDockable dockable) {
            for (CFocusListener listener : CListenerCollection.this.getFocusListeners()) {
                listener.focusGained(dockable);
            }
        }

        public void focusLost(CDockable dockable) {
            for (CFocusListener listener : CListenerCollection.this.getFocusListeners()) {
                listener.focusLost(dockable);
            }
        }
    };
    private List<CVetoFocusListener> vetoFocusListeners = new ArrayList<CVetoFocusListener>();
    private CVetoFocusListener vetoFocusListener = new CVetoFocusListener(){

        public boolean willGainFocus(CDockable dockable) {
            for (CVetoFocusListener listener : CListenerCollection.this.getVetoFocusListeners()) {
                if (listener.willGainFocus(dockable)) continue;
                return false;
            }
            return true;
        }

        public boolean willLoseFocus(CDockable dockable) {
            for (CVetoFocusListener listener : CListenerCollection.this.getVetoFocusListeners()) {
                if (listener.willLoseFocus(dockable)) continue;
                return false;
            }
            return true;
        }
    };
    private List<CKeyboardListener> keyboardListeners = new ArrayList<CKeyboardListener>();
    private CKeyboardListener keyboardListener = new CKeyboardListener(){

        public boolean keyPressed(CDockable source, KeyEvent event) {
            for (CKeyboardListener listener : CListenerCollection.this.getKeyboardListeners()) {
                if (!listener.keyPressed(source, event)) continue;
                return true;
            }
            return false;
        }

        public boolean keyReleased(CDockable source, KeyEvent event) {
            for (CKeyboardListener listener : CListenerCollection.this.getKeyboardListeners()) {
                if (!listener.keyReleased(source, event)) continue;
                return true;
            }
            return false;
        }

        public boolean keyTyped(CDockable source, KeyEvent event) {
            for (CKeyboardListener listener : CListenerCollection.this.getKeyboardListeners()) {
                if (!listener.keyTyped(source, event)) continue;
                return true;
            }
            return false;
        }
    };
    private List<CDoubleClickListener> doubleClickListeners = new ArrayList<CDoubleClickListener>();
    private CDoubleClickListener doubleClickListener = new CDoubleClickListener(){

        public boolean clicked(CDockable source, MouseEvent event) {
            for (CDoubleClickListener listener : CListenerCollection.this.getDoubleClickListeners()) {
                if (!listener.clicked(source, event)) continue;
                return true;
            }
            return false;
        }
    };
    private List<CVetoClosingListener> vetoClosingListeners = new ArrayList<CVetoClosingListener>();
    private CVetoClosingListener vetoClosingListener = new CVetoClosingListener(){

        public void closing(CVetoClosingEvent event) {
            for (CVetoClosingListener listener : CListenerCollection.this.getVetoClosingListeners()) {
                listener.closing(event);
            }
        }

        public void closed(CVetoClosingEvent event) {
            for (CVetoClosingListener listener : CListenerCollection.this.getVetoClosingListeners()) {
                listener.closed(event);
            }
        }
    };
    private List<CDockableLocationListener> locationListeners = new ArrayList<CDockableLocationListener>();
    private CDockableLocationListener locationListener = new CDockableLocationListener(){

        public void changed(CDockableLocationEvent event) {
            for (CDockableLocationListener listener : CListenerCollection.this.getCDockableLocationListeners()) {
                listener.changed(event);
            }
        }
    };

    public void addCDockableStateListener(CDockableStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.stateListeners.add(listener);
    }

    public void removeCDockableStateListener(CDockableStateListener listener) {
        this.stateListeners.remove(listener);
    }

    public CDockableStateListener[] getCDockableStateListeners() {
        return this.stateListeners.toArray(new CDockableStateListener[this.stateListeners.size()]);
    }

    public CDockableLocationListener getCDockableLocationListener() {
        return this.locationListener;
    }

    public boolean hasCDockableLocationListeners() {
        return this.locationListeners.size() > 0;
    }

    public void addCDockableLocationListener(CDockableLocationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.locationListeners.add(listener);
    }

    public void removeCDockableLocationListener(CDockableLocationListener listener) {
        this.locationListeners.remove(listener);
    }

    public CDockableLocationListener[] getCDockableLocationListeners() {
        return this.locationListeners.toArray(new CDockableLocationListener[this.locationListeners.size()]);
    }

    public CDockableStateListener getCDockableStateListener() {
        return this.stateListener;
    }

    public void addCDockablePropertyListener(CDockablePropertyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.propertyListeners.add(listener);
    }

    public void removeCDockablePropertyListener(CDockablePropertyListener listener) {
        this.propertyListeners.remove(listener);
    }

    public CDockablePropertyListener[] getCDockablePropertyListeners() {
        return this.propertyListeners.toArray(new CDockablePropertyListener[this.propertyListeners.size()]);
    }

    public CDockablePropertyListener getCDockablePropertyListener() {
        return this.propertyListener;
    }

    public void addFocusListener(CFocusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.focusListeners.add(listener);
    }

    public void removeFocusListener(CFocusListener listener) {
        this.focusListeners.remove(listener);
    }

    public CFocusListener[] getFocusListeners() {
        return this.focusListeners.toArray(new CFocusListener[this.focusListeners.size()]);
    }

    public CFocusListener getFocusListener() {
        return this.focusListener;
    }

    public void addVetoFocusListener(CVetoFocusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.vetoFocusListeners.add(listener);
    }

    public void removeVetoFocusListener(CVetoFocusListener listener) {
        this.vetoFocusListeners.remove(listener);
    }

    public CVetoFocusListener[] getVetoFocusListeners() {
        return this.vetoFocusListeners.toArray(new CVetoFocusListener[this.vetoFocusListeners.size()]);
    }

    public CVetoFocusListener getVetoFocusListener() {
        return this.vetoFocusListener;
    }

    public void addKeyboardListener(CKeyboardListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.keyboardListeners.add(listener);
    }

    public void removeKeyboardListener(CKeyboardListener listener) {
        this.keyboardListeners.remove(listener);
    }

    public CKeyboardListener[] getKeyboardListeners() {
        return this.keyboardListeners.toArray(new CKeyboardListener[this.keyboardListeners.size()]);
    }

    public CKeyboardListener getKeyboardListener() {
        return this.keyboardListener;
    }

    public void addDoubleClickListener(CDoubleClickListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.doubleClickListeners.add(listener);
    }

    public void removeDoubleClickListener(CDoubleClickListener listener) {
        this.doubleClickListeners.remove(listener);
    }

    public CDoubleClickListener[] getDoubleClickListeners() {
        return this.doubleClickListeners.toArray(new CDoubleClickListener[this.doubleClickListeners.size()]);
    }

    public CDoubleClickListener getDoubleClickListener() {
        return this.doubleClickListener;
    }

    public CVetoClosingListener getVetoClosingListener() {
        return this.vetoClosingListener;
    }

    public void addVetoClosingListener(CVetoClosingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.vetoClosingListeners.add(listener);
    }

    public void removeVetoClosingListener(CVetoClosingListener listener) {
        this.vetoClosingListeners.remove(listener);
    }

    public boolean hasVetoClosingListeners() {
        return !this.vetoClosingListeners.isEmpty();
    }

    public CVetoClosingListener[] getVetoClosingListeners() {
        return this.vetoClosingListeners.toArray(new CVetoClosingListener[this.vetoClosingListeners.size()]);
    }
}

