/*
 * Decompiled with CFR 0.152.
 */
package de.renew.export.io.exportFormats;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.exportFormats.ExportFormatMultiAbstract;
import de.renew.plugin.command.CLCommand;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class ExportClCommand
implements CLCommand,
StatusDisplayer {
    private static final String SYNOPSIS = "Exports a drawing. Usage: ex <type> [drawing]+ [options]";
    private static final Logger LOGGER = Logger.getLogger(ExportClCommand.class);

    /*
     * WARNING - void declaration
     */
    public void execute(String[] args, PrintStream response) {
        DefaultParser parser = new DefaultParser();
        Options opts = new Options();
        opts.addOption("a", "accumulate", false, "n-to-1 export (only available for some formats, e.g. ShadowNetSystem)");
        opts.addOption("o", "output", true, "output file");
        ExportHolderImpl exporter = (ExportHolderImpl)DrawPlugin.getCurrent().getExportHolder();
        List<ExportFormat> formats = this.flattenedExportFormats();
        CommandLine line = null;
        try {
            line = parser.parse(opts, args);
        }
        catch (ParseException e1) {
            response.append("Could not parse command.\n");
            this.printHelp(response, formats, opts);
            return;
        }
        List argList = line.getArgList();
        if (argList.size() < 2) {
            response.append("Not enough arguments.\n");
            this.printHelp(response, formats, opts);
            return;
        }
        String type = (String)argList.remove(0);
        List files = argList;
        boolean accumulate = line.hasOption("a");
        if (files.size() > 1 && line.hasOption("o") && !accumulate) {
            response.append("Cannot export multiple drawings with custom output file (except for n-to-1 export).\n");
            this.printHelp(response, formats, opts);
            return;
        }
        ExportFormat exportFormat = null;
        String extension = type;
        for (ExportFormat exportFormat2 : formats) {
            LOGGER.debug((Object)exportFormat2);
            if (!exportFormat2.formatName().equalsIgnoreCase(type)) continue;
            exportFormat = exportFormat2;
            LOGGER.info((Object)(ExportClCommand.class.getSimpleName() + ": format is " + exportFormat2.formatName()));
            FileFilter fileFilter = exportFormat2.fileFilter();
            if (!(fileFilter instanceof SimpleFileFilter)) break;
            extension = ((SimpleFileFilter)fileFilter).getExtension();
            break;
        }
        if (exportFormat == null) {
            response.append("Export format not found.\n");
            return;
        }
        if (accumulate) {
            void var15_20;
            if (!exportFormat.canExportNto1()) {
                response.append("Export format does not support n-to-1 export.\n");
                return;
            }
            ArrayList<Drawing> drawings = new ArrayList<Drawing>();
            for (String filename : files) {
                LOGGER.info((Object)(ExportClCommand.class.getSimpleName() + ": add filename to n-to-1 export " + filename));
                File file = new File(filename);
                if (!file.exists()) continue;
                drawings.add(DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)this));
            }
            if (line.hasOption("o")) {
                File file = new File(line.getOptionValue("o"));
            } else {
                File file = new File(((Drawing)drawings.get(0)).getName() + ".sns");
            }
            exporter.saveDrawings(Collections.enumeration(drawings), exportFormat, (File)var15_20, (StatusDisplayer)this);
            LOGGER.info((Object)(ExportClCommand.class.getSimpleName() + ": exported n-to-1  " + var15_20.getAbsolutePath()));
        } else if (line.hasOption("o")) {
            this.exportSingleDrawing(exporter, exportFormat, extension, (String)files.get(0), line.getOptionValue("o"));
        } else {
            for (String string : files) {
                this.exportSingleDrawing(exporter, exportFormat, extension, string, null);
            }
        }
    }

    public List<ExportFormat> flattenedExportFormats() {
        ExportHolder exporter = DrawPlugin.getCurrent().getExportHolder();
        ExportFormat[] formats = exporter.allExportFormats();
        LinkedList<ExportFormat> exportFormatsQueue = new LinkedList<ExportFormat>(Arrays.asList(formats));
        ArrayList<ExportFormat> flattenedExportFormats = new ArrayList<ExportFormat>();
        while (!exportFormatsQueue.isEmpty()) {
            ExportFormat format = (ExportFormat)exportFormatsQueue.poll();
            if (format instanceof ExportFormatMultiAbstract) {
                ExportFormatMultiAbstract multiFormat = (ExportFormatMultiAbstract)format;
                List subformats = multiFormat.formats();
                for (ExportFormat subformat : subformats) {
                    exportFormatsQueue.add(subformat);
                }
                continue;
            }
            flattenedExportFormats.add(format);
        }
        Collections.sort(flattenedExportFormats, new Comparator<ExportFormat>(){

            @Override
            public int compare(ExportFormat o1, ExportFormat o2) {
                return o1.formatName().compareTo(o2.formatName());
            }
        });
        return flattenedExportFormats;
    }

    private void exportSingleDrawing(ExportHolderImpl exporter, ExportFormat format, String extension, String filename, String outputFile) {
        LOGGER.info((Object)(ExportClCommand.class.getName() + ": filename is " + filename));
        File file = new File(filename);
        if (file.exists()) {
            Drawing drawing = DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)this);
            LOGGER.info((Object)(ExportClCommand.class.getName() + ": drawing is " + drawing.getName()));
            File exportFile = outputFile == null ? new File(drawing.getFilename().getAbsoluteFile().getParentFile(), drawing.getName() + "." + extension) : new File(outputFile);
            LOGGER.info((Object)(ExportClCommand.class.getName() + ": path is " + String.valueOf(exportFile)));
            exporter.saveDrawing(drawing, format, exportFile, (StatusDisplayer)this);
        }
    }

    public String getDescription() {
        return "Exports a drawing. Usage: ex <type> [drawing]+ [options] Type ex for a list of supported formats and options.";
    }

    public void showStatus(String message) {
        LOGGER.info((Object)(ExportClCommand.class.getName() + " Status: " + message));
    }

    public String getArguments() {
        List<ExportFormat> formats = this.flattenedExportFormats();
        Object arguments = "";
        if (formats.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (int i = 0; i < formats.size(); ++i) {
                ExportFormat format = formats.get(i);
                sb.append(format.formatName());
                if (i >= formats.size() - 1) continue;
                sb.append("|");
            }
            sb.append(")");
            sb.append(" ");
            arguments = sb.toString();
        }
        arguments = (String)arguments + "[fileNames|-o|-a]*";
        return arguments;
    }

    private void printHelp(PrintStream response, List<ExportFormat> formats, Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        String header = "Exports a drawing.";
        formatter.printHelp(new PrintWriter(response, true), 74, "ex <type> [drawing]+", header, opts, 1, 3, null, true);
        response.append("List of available formats:\n");
        for (ExportFormat exportFormat : formats) {
            response.append(ExportClCommand.class.getSimpleName() + ": " + String.valueOf(exportFormat) + "\n");
            if (!exportFormat.canExportNto1()) continue;
            response.append(ExportClCommand.class.getSimpleName() + ": " + String.valueOf(exportFormat) + " -a file.rnw [morefiles.rnw] (n-to-1)\n");
        }
    }
}

