/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ptchannel.single;

import de.renew.formalism.java.InscriptionParser;
import de.renew.formalism.java.JavaNetParser;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.pt.SinglePTNetCompiler;
import de.renew.net.TransitionInscription;
import de.renew.ptchannel.single.PTCTransitionCompiler;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowDeclarationNode;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.SyntaxException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;

public class SinglePTNetWithChannelCompiler
extends SinglePTNetCompiler {
    private final PTCTransitionCompiler _transitionCompiler = new PTCTransitionCompiler(false, false, false);
    private ParsedDeclarationNode _declaration;

    public String checkTransitionInscription(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        String trans = this._transitionCompiler.checkTransitionInscription(inscription, special, shadowNet);
        this._declaration = this._transitionCompiler.makeDeclarationNode(shadowNet);
        return trans;
    }

    public String checkDeclarationNode(String inscr, boolean special, ShadowNet shadowNet) throws SyntaxException {
        this.parseDeclarationNode(inscr);
        return "declaration";
    }

    ParsedDeclarationNode parseDeclarationNode(String inscr) throws SyntaxException {
        if (inscr != null) {
            InscriptionParser parser = this.makeParser(inscr);
            try {
                return parser.DeclarationNode();
            }
            catch (ParseException e) {
                throw PTCTransitionCompiler.makeSyntaxException((ParseException)e);
            }
        }
        return this.makeEmptyDeclarationNode();
    }

    protected ParsedDeclarationNode makeEmptyDeclarationNode() {
        return new ParsedDeclarationNode();
    }

    public void parseDeclarations(ShadowNet shadowNet) throws SyntaxException {
        this.makeDeclarationNode(shadowNet);
    }

    public void makeDeclarationNode(ShadowNet shadowNet) throws SyntaxException {
        ShadowDeclarationNode node = this.findDeclarationNode(shadowNet);
        this._declaration = node == null ? this.makeEmptyDeclarationNode() : this.compile(node);
    }

    protected ParsedDeclarationNode compile(ShadowDeclarationNode declarationNode) throws SyntaxException {
        try {
            return this.parseDeclarationNode(declarationNode.inscr);
        }
        catch (SyntaxException e) {
            throw e.addObject((Object)declarationNode);
        }
    }

    protected Collection<TransitionInscription> compileTransitionInscription(ShadowInscription inscription) throws SyntaxException {
        return this._transitionCompiler.makeInscriptions(inscription, this.lookup, true, this._declaration, this._loopbackNetLoader);
    }

    protected InscriptionParser makeParser(String inscr) {
        JavaNetParser parser = new JavaNetParser((Reader)new StringReader(inscr));
        parser.setNetLoader(this._loopbackNetLoader);
        return parser;
    }

    public String checkArcInscription(String inscr, boolean special, ShadowNet shadowNet) throws SyntaxException {
        return this._transitionCompiler.checkArcInscription(inscr, special, shadowNet);
    }

    protected void compileArc(ShadowArc shadowArc) throws SyntaxException {
        try {
            super.compileArc(shadowArc);
        }
        catch (SyntaxException e) {
            if (shadowArc.shadowArcType == 1) {
                this._transitionCompiler.compileArc(shadowArc, this._declaration, this.lookup);
            }
            throw new SyntaxException("Only ordinary arcs are allowed.").addObject((Object)shadowArc);
        }
    }

    protected PTCTransitionCompiler getTransitionCompiler() {
        return this._transitionCompiler;
    }

    protected ParsedDeclarationNode getDeclaration() {
        return this._declaration;
    }
}

