/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.menu;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.menu.MenuViewItem;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMenuHandler<I extends JMenuItem, D extends StandardDockAction>
implements MenuViewItem<JComponent> {
    protected I item;
    protected Dockable dockable;
    protected D action;
    private Listener listener;

    public AbstractMenuHandler(D action, Dockable dockable, I item) {
        this.action = action;
        this.dockable = dockable;
        this.item = item;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public D getAction() {
        return this.action;
    }

    @Override
    public JMenuItem getItem() {
        return this.item;
    }

    @Override
    public void bind() {
        if (this.action != null) {
            if (this.listener == null) {
                this.action.bind(this.dockable);
                this.listener = new Listener();
                this.action.addDockActionListener(this.listener);
                if (this.item != null) {
                    ((JMenuItem)this.item).setEnabled(this.action.isEnabled(this.dockable));
                    ((AbstractButton)this.item).setIcon(this.getIcon(ActionContentModifier.NONE_HORIZONTAL, new ActionContentModifier[0]));
                    this.updateDisabledIcon();
                    ((AbstractButton)this.item).setText(this.action.getText(this.dockable));
                    ((JComponent)this.item).setToolTipText(this.action.getTooltipText(this.dockable));
                }
            } else {
                throw new IllegalStateException("Handler is already bound");
            }
        }
    }

    private void updateDisabledIcon() {
        Icon icon = this.getIcon(ActionContentModifier.DISABLED_HORIZONTAL, ActionContentModifier.NONE_HORIZONTAL, ActionContentModifier.NONE);
        if (icon == null) {
            icon = this.getIcon(ActionContentModifier.NONE_HORIZONTAL, new ActionContentModifier[0]);
            icon = DockUtilities.disabledIcon(this.getItem(), icon);
        }
        ((AbstractButton)this.item).setDisabledIcon(icon);
    }

    private Icon getIcon(ActionContentModifier modifier, ActionContentModifier ... limits) {
        LinkedList<ActionContentModifier> modifiers = new LinkedList<ActionContentModifier>();
        modifiers.add(modifier);
        while (!modifiers.isEmpty()) {
            modifier = (ActionContentModifier)modifiers.remove(0);
            if (this.isLimited(modifier, limits)) continue;
            Icon icon = this.action.getIcon(this.dockable, modifier);
            if (icon != null) {
                return icon;
            }
            for (ActionContentModifier backup : modifier.getBackup()) {
                modifiers.add(backup);
            }
        }
        return null;
    }

    private boolean isLimited(ActionContentModifier modifier, ActionContentModifier ... limits) {
        for (ActionContentModifier limit : limits) {
            if (!limit.equals(modifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unbind() {
        if (this.action != null) {
            if (this.listener != null) {
                this.action.unbind(this.dockable);
                this.action.removeDockActionListener(this.listener);
                this.listener = null;
            } else {
                throw new IllegalStateException("Handler is already unbound");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements StandardDockActionListener {
        private Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (AbstractMenuHandler.this.item != null) {
                ((JMenuItem)AbstractMenuHandler.this.item).setEnabled(action.isEnabled(AbstractMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction action, ActionContentModifier modifier, Set<Dockable> dockables) {
            if (AbstractMenuHandler.this.item != null) {
                if (modifier == null || modifier == ActionContentModifier.NONE_HORIZONTAL) {
                    ((AbstractButton)AbstractMenuHandler.this.item).setIcon(AbstractMenuHandler.this.getIcon(ActionContentModifier.NONE_HORIZONTAL, new ActionContentModifier[0]));
                } else if (modifier == null || modifier == ActionContentModifier.NONE) {
                    ((AbstractButton)AbstractMenuHandler.this.item).setIcon(AbstractMenuHandler.this.getIcon(ActionContentModifier.NONE_HORIZONTAL, new ActionContentModifier[0]));
                }
                if (modifier == null || modifier == ActionContentModifier.DISABLED || modifier == ActionContentModifier.DISABLED_HORIZONTAL) {
                    AbstractMenuHandler.this.updateDisabledIcon();
                }
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (AbstractMenuHandler.this.item != null) {
                ((AbstractButton)AbstractMenuHandler.this.item).setText(action.getText(AbstractMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (AbstractMenuHandler.this.item != null) {
                ((JComponent)AbstractMenuHandler.this.item).setToolTipText(action.getTooltipText(AbstractMenuHandler.this.dockable));
            }
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction action, Set<Dockable> dockables) {
        }
    }
}

