/*
 * Decompiled with CFR 0.152.
 */
package de.renew.windowmanagement;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CKeyboardListener;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.util.Path;
import de.renew.windowmanagement.RenewMenuBar;
import de.renew.windowmanagement.RenewShutdownHook;
import de.renew.windowmanagement.UnknownMenuSectionException;
import de.renew.windowmanagement.Workbench;
import de.renew.windowmanagement.WorkbenchImpl;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;

public class WorkbenchProxy
implements Workbench {
    private boolean _fwithGui = false;
    private WorkbenchImpl _proxy;
    private HashMap<String, MultipleCDockableFactory> _fFactoryMap = new HashMap();
    private LinkedHashSet<JPanel> _fPanelSet = new LinkedHashSet();
    private ArrayList<MenuBarEntry> _fmenu = new ArrayList();
    private HashMap<DefaultSingleCDockable, Path> _fViewMap = new HashMap();
    private final ArrayList<RenewShutdownHook> _fShutdownHooks = new ArrayList();
    private LinkedHashSet<WeakReference> _fControlListeners = new LinkedHashSet();
    private LinkedHashSet<WeakReference> _fFocusListeners = new LinkedHashSet();
    private LinkedHashSet<WeakReference> _fVetoListeners = new LinkedHashSet();
    private LinkedHashSet<WeakReference> _fKeyboardListeners = new LinkedHashSet();

    @Override
    public JFrame getMainFrame() {
        if (this._fwithGui) {
            return this.ensureProxyInitialized().getMainFrame();
        }
        return null;
    }

    @Override
    public void showStatus(String string) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().showStatus(string);
        }
    }

    @Override
    public void addStaticPanel(JPanel panel) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().addStaticPanel(panel);
        } else {
            this._fPanelSet.add(panel);
        }
    }

    @Override
    public void addEditorWindow(MultipleCDockableLayout editor, String factoryID) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().addEditorWindow(editor, factoryID);
        }
    }

    @Override
    public void newEditorWindow(String factoryID) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().newEditorWindow(factoryID);
        }
    }

    @Override
    public void registerControlListener(CControlListener listener) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().registerControlListener(listener);
        } else {
            this._fControlListeners.add(new WeakReference<CControlListener>(listener));
        }
    }

    @Override
    public void registerEditorFactory(MultipleCDockableFactory factory, String id) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().registerEditorFactory(factory, id);
        } else {
            this._fFactoryMap.put(id, factory);
        }
    }

    @Override
    public void registerMenu(JMenu menu) {
        this._fmenu.add(new MenuBarEntry(menu, 4));
        if (this._fwithGui) {
            this.ensureProxyInitialized().registerMenu(menu);
        }
    }

    @Override
    public void registerMenu(JMenu menu, int index) throws UnknownMenuSectionException {
        this._fmenu.add(new MenuBarEntry(menu, index));
        if (this._fwithGui) {
            this.ensureProxyInitialized().registerMenu(menu, index);
        }
    }

    @Override
    public void removeMenu(JMenu menu) {
        this._fmenu.remove(new MenuBarEntry(menu, 0));
        EventQueue.invokeLater(() -> {
            if (this._fwithGui) {
                this.ensureProxyInitialized().removeMenu(menu);
            }
        });
    }

    @Override
    public void close(MultipleCDockable dockable) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().close(dockable);
        }
    }

    @Override
    public void close(SingleCDockable dockable) {
        EventQueue.invokeLater(() -> {
            if (this._fwithGui) {
                this.ensureProxyInitialized().close(dockable);
            }
        });
    }

    @Override
    public void addViewWindow(DefaultSingleCDockable dockable, Path path) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().addViewWindow(dockable, path);
        } else {
            this._fViewMap.put(dockable, path);
        }
    }

    protected synchronized void requestClose() {
        assert (EventQueue.isDispatchThread());
        if (!this._fwithGui) {
            return;
        }
        for (RenewShutdownHook hook : this._fShutdownHooks) {
            if (hook.canClose()) {
                hook.exit();
                continue;
            }
            this._fwithGui = true;
            return;
        }
        this._proxy.destroy();
        this.ensureProxyFreed();
    }

    @Override
    public void registerShutdownHook(RenewShutdownHook hook) {
        this._fShutdownHooks.add(hook);
    }

    private synchronized WorkbenchImpl ensureProxyInitialized() {
        if (this._proxy == null) {
            RenewMenuBar bar = new RenewMenuBar();
            for (MenuBarEntry entry : this._fmenu) {
                try {
                    bar.addMenu(entry._menu, entry._section);
                }
                catch (UnknownMenuSectionException e) {
                    e.printStackTrace();
                }
            }
            JFrame frame = new JFrame();
            this.addWindowListeners(frame);
            this._proxy = new WorkbenchImpl(bar, frame);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry<String, MultipleCDockableFactory> entry : WorkbenchProxy.this._fFactoryMap.entrySet()) {
                        WorkbenchProxy.this._proxy.registerEditorFactory(entry.getValue(), entry.getKey());
                    }
                    for (WeakReference weakReference : WorkbenchProxy.this._fControlListeners) {
                        WorkbenchProxy.this._proxy.registerControlListener((CControlListener)weakReference.get());
                    }
                    for (WeakReference weakReference : WorkbenchProxy.this._fFocusListeners) {
                        WorkbenchProxy.this._proxy.registerFocusListener((CFocusListener)weakReference.get());
                    }
                    for (WeakReference weakReference : WorkbenchProxy.this._fVetoListeners) {
                        WorkbenchProxy.this._proxy.registerVetoClosingListener((CVetoClosingListener)weakReference.get());
                    }
                    for (WeakReference weakReference : WorkbenchProxy.this._fKeyboardListeners) {
                        WorkbenchProxy.this._proxy.registerKeyboardListener((CKeyboardListener)weakReference.get());
                    }
                    for (JPanel jPanel : WorkbenchProxy.this._fPanelSet) {
                        WorkbenchProxy.this._proxy.addStaticPanel(jPanel);
                    }
                    for (Map.Entry<String, Object> entry : WorkbenchProxy.this._fViewMap.entrySet()) {
                        WorkbenchProxy.this._proxy.addViewWindow((DefaultSingleCDockable)entry.getKey(), (Path)entry.getValue());
                    }
                }
            });
        }
        return this._proxy;
    }

    private void ensureProxyFreed() {
        this._proxy = null;
        this._fwithGui = false;
    }

    @Override
    public void openGui() {
        this._fwithGui = true;
        this.ensureProxyInitialized();
    }

    @Override
    public void registerFocusListener(CFocusListener listener) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().registerFocusListener(listener);
        } else {
            this._fFocusListeners.add(new WeakReference<CFocusListener>(listener));
        }
    }

    @Override
    public void registerVetoClosingListener(CVetoClosingListener listener) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().registerVetoClosingListener(listener);
        } else {
            this._fVetoListeners.add(new WeakReference<CVetoClosingListener>(listener));
        }
    }

    @Override
    public void registerKeyboardListener(CKeyboardListener listener) {
        if (this._fwithGui) {
            this.ensureProxyInitialized().registerKeyboardListener(listener);
        } else {
            this._fKeyboardListeners.add(new WeakReference<CKeyboardListener>(listener));
        }
    }

    protected void addWindowListeners(JFrame frame) {
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WorkbenchProxy.this.requestClose();
                    }
                });
            }

            @Override
            public void windowDeactivated(WindowEvent event) {
            }
        });
    }

    private class MenuBarEntry {
        protected JMenu _menu;
        protected int _section;

        MenuBarEntry(JMenu menu, int section) {
            this._menu = menu;
            this._section = section;
        }

        public boolean equals(Object o) {
            if (o instanceof MenuBarEntry) {
                return ((MenuBarEntry)o)._menu == this._menu;
            }
            return false;
        }
    }

    private class ToolbarEntry {
        protected String _name;
        protected Map<AbstractButton, Component> _buttonBoxMap;
        protected boolean _immediatelyVisible;

        ToolbarEntry(String name, Map<AbstractButton, Component> buttonBoxMap, boolean immediatelyVisible) {
            this._name = name;
            this._buttonBoxMap = buttonBoxMap;
            this._immediatelyVisible = immediatelyVisible;
        }

        public boolean equals(Object otherEntry) {
            if (otherEntry instanceof ToolbarEntry) {
                return ((ToolbarEntry)otherEntry)._name == this._name;
            }
            return false;
        }
    }
}

