/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InfoCommand
implements CLCommand {
    public static final Logger LOGGER = Logger.getLogger(InfoCommand.class);

    @Override
    public void execute(String[] args, PrintStream response) {
        IPlugin found;
        String pluginName = CollectionLister.toString(args, " ");
        if (args.length > 0 && ("-c".equals(args[0]) || "c".equals(args[0]) || "--comments".equals(args[0]) || "comments".equals(args[0]))) {
            response.println("Please use list command instead!");
        }
        if ((found = PluginManager.getInstance().getPluginByName(pluginName)) == null) {
            LOGGER.debug((Object)("InfoCommand: did not find Plugin with name " + pluginName));
            return;
        }
        try {
            PluginProperties props = found.getProperties();
            response.println(InfoCommand.renderProperties(props));
        }
        catch (ArrayIndexOutOfBoundsException props) {
        }
        catch (NumberFormatException e) {
            response.println("cleanup canceled.");
        }
        catch (Exception e) {
            response.println("cleanup canceled: " + String.valueOf(e) + "; " + e.getMessage());
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String renderProperties(PluginProperties props) {
        StringBuffer result = new StringBuffer();
        result.append("Properties of plugin ");
        result.append(props.getName());
        result.append("\n\tloaded from ");
        result.append(props.getURL());
        result.append("\n\t");
        String mainClass = props.getMainClass();
        if ("".equals(mainClass)) {
            result.append("no main class");
        } else {
            result.append("main class is ");
            result.append(mainClass);
        }
        result.append("\n\tprovides ");
        result.append(CollectionLister.toString(props.getProvisions()));
        result.append("\n\trequires ");
        result.append(CollectionLister.toString(props.getRequirements()));
        result.append("\n\tversion information \n\t\t");
        result.append(props.getVersion());
        result.append("\n\t\t");
        result.append(props.getVersionDate());
        result.append("\n\t\t");
        result.append(props.getVersionText());
        result.append("\n");
        Vector<Object> pNames = new Vector<String>();
        pNames.addAll(props.getKeys());
        StringBuffer other = new StringBuffer();
        Collections.sort(pNames);
        for (String string : pNames) {
            if (!props.isKnownProperty(string)) continue;
            other.append("\t");
            other.append(string);
            other.append("=");
            other.append(props.getProperty(string));
            other.append("\n");
        }
        if (other.length() > 0) {
            result.append("Other properties:\n");
            result.append(other);
        }
        pNames = new Vector<String>(props.getUnsetProperties());
        StringBuffer stringBuffer = new StringBuffer();
        Collections.sort(pNames);
        for (String string : pNames) {
            if (!props.isKnownProperty(string)) continue;
            stringBuffer.append("\t");
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(props.getProperty(string));
            stringBuffer.append("\n");
        }
        if (stringBuffer.length() > 0) {
            result.append("Unset properties:\n");
            result.append(stringBuffer);
        }
        return result.toString();
    }

    @Override
    public String getDescription() {
        return "view properties of a loaded plugin.";
    }

    @Override
    public String getArguments() {
        return "pluginNames";
    }
}

