/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.IPlugin;
import de.renew.plugin.IPluginManagerListener;
import de.renew.plugin.PluginManager;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class PluginServiceTracker
implements IPluginManagerListener {
    public static final Logger LOGGER = Logger.getLogger(PluginServiceTracker.class);
    private String _providedService;
    protected Collection<IPlugin> _providerList;
    private PluginManager _mgr;

    public PluginServiceTracker(String providedService) {
        this._providedService = providedService;
        this._providerList = new ArrayList<IPlugin>();
        this._mgr = PluginManager.getInstance();
    }

    public void open() {
        this._mgr.addPluginManagerListener(this);
        this.bindServices(this._mgr.getPluginsProviding(this._providedService));
    }

    public void close() {
        this._mgr.removePluginManagerListener(this);
        this.unbindServices(this._mgr.getPluginsProviding(this._providedService));
    }

    private void bindServices(Collection<IPlugin> providerList) {
        if (providerList != null) {
            for (IPlugin provider : providerList) {
                this.bindService(provider);
            }
        }
    }

    private void unbindServices(Collection<IPlugin> providerList) {
        for (IPlugin provider : providerList) {
            this.unbindService(provider);
        }
        assert (this._providerList.isEmpty()) : "There is a difference between\nthe provider list of the plugin manager and the plugin service tracker (" + String.valueOf(this) + ").\n[Tracked provider service: " + this._providedService + "].\nRemaining plugins : " + String.valueOf(this._providerList) + ".";
    }

    protected void bindService(IPlugin provider) {
        if (provider != null && provider.getProperties().getProvisions().contains(this._providedService)) {
            this._providerList.add(provider);
        }
    }

    protected void unbindService(IPlugin provider) {
        if (provider != null && this._providerList.contains(provider)) {
            this._providerList.remove(provider);
        }
    }

    @Override
    public synchronized void serviceAdded(String service, IPlugin provider) {
        if (provider != null) {
            this.bindService(provider);
        }
    }

    @Override
    public synchronized void serviceRemoved(String service, IPlugin provider) {
        if (provider != null) {
            this.unbindService(provider);
        }
    }
}

