/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.LogStrategy;
import de.renew.plugin.PluginManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class DefaultLogStrategy
implements LogStrategy {
    public static final String LOG_CONFIG_PROPERTY_NAME = "log4j.configuration";
    public static final String LOG_HOME_PROPERTY_NAME = "logs.home";
    public static final String LOG_HOME_DEFAULT_LOCATION = "renewlogs";
    public static final String LOG4J_PROPERTIES_FILE = "log4j.properties";
    public static final String LOG4J_XML_FILE = "log4j.xml";

    @Override
    public void configureLogging() {
        Vector<String> logMessages = new Vector<String>();
        String logConfigSource = null;
        if ((logConfigSource = this.tryConfigurationByPropertyName(logMessages, logConfigSource)) == null) {
            try {
                URL url = PluginManager.getLoaderLocation();
                String base = url.toExternalForm();
                base = base.substring(0, base.lastIndexOf("/"));
                logConfigSource = this.tryXMLConfigurationHome(logMessages, logConfigSource, base);
                if (logConfigSource == null) {
                    logConfigSource = this.tryPropertiesConfigurationHome(logMessages, logConfigSource, base);
                }
            }
            catch (Exception e) {
                logMessages.add(e.toString());
            }
            if (logConfigSource == null) {
                logConfigSource = this.fallbackConfiguration(logMessages);
            }
        }
        if (!logMessages.isEmpty()) {
            Iterator<String> i = logMessages.iterator();
            while (i.hasNext()) {
                PluginManager.LOGGER.error((Object)i.next());
            }
        }
        if (PluginManager.LOGGER.isDebugEnabled()) {
            PluginManager.LOGGER.debug((Object)("Used " + logConfigSource + " to configure Log4j."));
        }
    }

    private String fallbackConfiguration(Vector<String> logMessages) {
        ConsoleAppender failsafeAppender = new ConsoleAppender((Layout)new SimpleLayout());
        failsafeAppender.setThreshold((Priority)Level.INFO);
        BasicConfigurator.configure((Appender)failsafeAppender);
        logMessages.add("No log4j configuration file found, falling back to failsaife settings.");
        String logConfigSource = "failsafe settings";
        return logConfigSource;
    }

    private String tryPropertiesConfigurationHome(Vector<String> logMessages, String logConfigSource, String base) throws MalformedURLException, URISyntaxException, IOException, FileNotFoundException {
        URL url = new URL(base + "/config/log4j.properties");
        File defaultConfigFile = new File(new URI(url.toExternalForm()));
        File userConfigFile = new File(String.valueOf(PluginManager.getPreferencesLocation()) + File.separator + ".log4j.properties");
        StringBuffer propsSource = new StringBuffer();
        Properties defaultProps = new Properties();
        boolean foundProps = false;
        if (defaultConfigFile.exists() && defaultConfigFile.isFile()) {
            defaultProps.load(new FileInputStream(defaultConfigFile));
            propsSource.append(defaultConfigFile.getAbsolutePath());
            foundProps = true;
        }
        if (userConfigFile.exists() && userConfigFile.isFile()) {
            defaultProps.load(new FileInputStream(userConfigFile));
            if (foundProps) {
                propsSource.append(" and ");
            }
            propsSource.append(userConfigFile.getAbsolutePath());
            foundProps = true;
        } else {
            File oldLocationOfConfigFile = new File(System.getProperty("user.home") + File.separator + ".log4j.properties");
            if (oldLocationOfConfigFile.exists() && oldLocationOfConfigFile.isFile()) {
                logMessages.add("The default location for the configuration file of log4j logging was moved from the users' home folder to the \"" + String.valueOf(PluginManager.getPreferencesLocation()) + "\" sub-directory.");
            }
        }
        if (foundProps) {
            try {
                PropertyConfigurator.configure((Properties)defaultProps);
                logConfigSource = propsSource.toString();
            }
            catch (Exception e) {
                logMessages.add("An error occured during the configuration of the logging framework using the properties configuration file(s) " + propsSource.toString() + ". Error was: " + e.toString());
            }
        }
        return logConfigSource;
    }

    private String tryXMLConfigurationHome(Vector<String> logMessages, String logConfigSource, String base) throws MalformedURLException, URISyntaxException, FactoryConfigurationError {
        if (System.getProperty(LOG_HOME_PROPERTY_NAME) == null) {
            File logDir = new File(String.valueOf(PluginManager.getPreferencesLocation()) + File.separator + LOG_HOME_DEFAULT_LOCATION);
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            if (!logDir.isDirectory()) {
                logDir = logDir.getParentFile();
            } else {
                System.setProperty(LOG_HOME_PROPERTY_NAME, logDir.getAbsolutePath());
            }
        }
        URL url = new URL(base + "/config/log4j.xml");
        File defaultConfigFile = new File(new URI(url.toExternalForm()));
        File userConfigFile = new File(String.valueOf(PluginManager.getPreferencesLocation()) + File.separator + ".log4j.xml");
        if (userConfigFile.exists() && userConfigFile.isFile()) {
            defaultConfigFile = userConfigFile;
        }
        if (defaultConfigFile.exists() && defaultConfigFile.isFile()) {
            try {
                DOMConfigurator.configure((String)defaultConfigFile.getAbsolutePath());
                logConfigSource = defaultConfigFile.getAbsolutePath();
            }
            catch (Exception e) {
                logMessages.add("An error occured during the configuration of the logging framework using the xml configuration file in the default config directory of the renew distribution.Error was: " + e.toString());
            }
        }
        return logConfigSource;
    }

    private String tryConfigurationByPropertyName(Vector<String> logMessages, String logConfigSource) throws FactoryConfigurationError {
        try {
            String configLocation = System.getProperty(LOG_CONFIG_PROPERTY_NAME);
            if (configLocation != null) {
                if (configLocation.endsWith(".xml")) {
                    DOMConfigurator.configure((String)configLocation);
                } else {
                    PropertyConfigurator.configure((String)configLocation);
                }
                logConfigSource = configLocation;
            }
        }
        catch (Exception e) {
            logMessages.add("A error occured while configuring the logging framework using the configuration file given by the property log4j.configuration. The following exception was thrown: " + e.toString());
        }
        return logConfigSource;
    }
}

